/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.function.library;


import java.util.HashMap;
import java.util.Map;

import reduction.ExprCopy;
import cfg.Application;
import cfg.IntConstant;
import cfg.IrReplaceExprTraverser;
import cfg.IrType;
import cfg.expression.CallExprLinked;
import cfg.expression.Expression;
import cfg.expression.IntegerExpr;
import cfg.expression.IntegerOp;
import cfg.function.LibFunction;
import cfg.function.PrgFunction;
import cfg.function.system.SystemFunctions;

public class FuncReplacer extends IrReplaceExprTraverser<Void> {
  private PrgFunction acfunc = null;

  public static void process(Application app) {
    Map<Long, PrgFunction> funcs = new HashMap<Long, PrgFunction>();

    FuncReplacer replacer = new FuncReplacer();
    replacer.visitCollection(app.getFunctions(), null);

    for (PrgFunction func : funcs.values()) {
      app.getFunctions().add(func);
    }
  }

  @Override
  protected void visitPrgFunction(PrgFunction obj, Void param) {
    assert (acfunc == null);
    acfunc = obj;
    super.visitPrgFunction(obj, param);
    assert (acfunc == obj);
    acfunc = null;
  }

  @Override
  protected Expression visitCallExprLinked(CallExprLinked obj, Void param) {
    if (obj.getFunc().getIrType() != IrType.FuncLibrary) {
      return obj;
    }
    LibFunction func = (LibFunction) obj.getFunc();

    if ("malloc".equals(func.getName())) {
      CallExprLinked call = new CallExprLinked(SystemFunctions.ptrNew);

      Expression expr = obj.getParam().get(0);

      // PointerArithmeticMatcher matcher = new PointerArithmeticMatcher();
      // matcher.parse(new IrItr(expr));
      // if (matcher.hasError()) {
      // throw new RuntimeException("Malloc param not parsable: " + matcher.getError());
      // }
      // call.getParam().add(matcher.getConverted());
      call.getParam().add(new IntegerExpr(expr, new IntConstant(4), IntegerOp.Div));
      return call;
    } else if ("free".equals(func.getName())) {
      CallExprLinked call = new CallExprLinked(SystemFunctions.ptrDestroy);
      call.getParam().add(ExprCopy.copy(obj.getParam().get(0)));
      return call;
    } else {
      System.out.println("Unknown library function: " + func.getName());
    }

    return obj;
  }

}
