/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.function.library;


import java.util.HashSet;

import cfg.function.LibFunction;
/**
 * Functions of library like libc, functions like printf puts
 * @author urs
 *
 */
public class LibraryFunctions {
  private HashSet<LibFunction> functions = new HashSet<LibFunction>();

  protected LibFunction find(String name) {
    for (LibFunction func : functions) {
      if (func.getName().equals(name)) {
        return func;
      }
    }
    return null;
  }

  public void addFunction(LibFunction func) {
    assert (find(func.getName()) == null);
    functions.add(func);
  }

  public LibFunction getFunction(String name) {
    LibFunction res = find(name);
    if (res == null) {
      throw new RuntimeException("Library function not found: " + name);
    }
    return res;
  }

  public HashSet<LibFunction> getFunctions() {
    return functions;
  }
}
