/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.linker;

import knowledge.KnowFuncByAddr;
import knowledge.KnowledgeBase;
import cfg.Application;
import cfg.IrReplaceExprTraverser;
import cfg.expression.CallExprLinked;
import cfg.expression.CallExprPointer;
import cfg.expression.CallExprUnlinked;
import cfg.expression.Expression;
import cfg.function.Function;

public class FunctionLinker extends IrReplaceExprTraverser<Void> {
  private KnowFuncByAddr funcAddr;

  static public void link(Application app) {
    FunctionLinker linker = new FunctionLinker(app.getKb());
    linker.visitCollection(app.getFunctions(), null);
  }

  public FunctionLinker(KnowledgeBase kb) {
    super();
    funcAddr = (KnowFuncByAddr) kb.getEntry(KnowFuncByAddr.class);
  }

  protected Expression visitCallExprPointer(CallExprPointer obj, Void param) {
    return super.visitCallExprPointer(obj, param);
  }

  @Override
  protected Expression visitCallExprUnlinked(CallExprUnlinked obj, Void param) {
    Function func = funcAddr.findFunction(obj.getAddr());
    if (func == null) {
      throw new RuntimeException("Function not found: " + obj);
    }

    CallExprLinked call = new CallExprLinked(func);
    call.setParam(obj.getParam());
    return call;
  }

}
