/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.linker;

import graph.DominanceFrontier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;
import cfg.function.Function;
import cfg.variable.SsaVariable;
import cfg.variable.VarComp;
import cfg.variable.VariableName;

public class PhiInserter {
  private List<VariableName>                    globals = new ArrayList<VariableName>();
  private Function                              func;
  private DominanceFrontier<BasicBlock, BbEdge> df;

  public PhiInserter(Function func, DominanceFrontier<BasicBlock, BbEdge> df) {
    super();
    this.df = df;
    this.func = func;
  }

  public void doWork() {
    DefUseKillVisitor visitor = new DefUseKillVisitor();
    visitor.visit(func, null);

    // If a variable is used but never defined it has to be a global variable
    // it does not hold for definitions for variables
    for (Set<VariableName> g : visitor.getUse().values()) {
      globals.addAll(g);
    }

    Collections.sort(globals, new VarComp());   // needed to make output deterministic
    int number = 0;

    for (VariableName x : globals) {
      Set<BasicBlock> blocks = visitor.getBlocks().get(x);
      LinkedList<BasicBlock> worklist = new LinkedList<BasicBlock>(blocks);
      for (int i = 0; i < worklist.size(); i++) {
        BasicBlock b = worklist.get(i);
        for (BasicBlock d : df.getDf().get(b)) {
          if (!d.hasPhiFor(x)) {
            number--;
            d.insertPhi(new SsaVariable(x, number));
            if (!worklist.contains(d)) {
              worklist.add(d);
            }
          }
        }
      }
    }
  }

}
