/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.linker;

import disassembler.diStorm3.Registers;

public class RegSymTable extends SymTable {

	public RegSymTable() {
		super();
		
		addAlias( Registers.EAX, Registers.AX, Registers.AH, Registers.AL );
		addAlias( Registers.EBX, Registers.BX, Registers.BH, Registers.BL );
		addAlias( Registers.ECX, Registers.CX, Registers.CH, Registers.CL );
		addAlias( Registers.EDX, Registers.DX, Registers.DH, Registers.DL );
		
		addAlias( Registers.EBP, Registers.BP );
		addAlias( Registers.ESI, Registers.SI );
		addAlias( Registers.EDI, Registers.DI );
		addAlias( Registers.ESP, Registers.SP );
	}

}
