/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.matcher;

import cfg.IrType;
import cfg.expression.CallExprLinked;
import cfg.function.LibFunction;

public class NoretCallMatcher extends Matcher {
  private boolean doesReturn = true;
  
  public boolean doesReturn() {
    return doesReturn;
  }

  @Override
  protected void doParse() {
    switch (stream.peek().getIrType()) {
      case AssignmentStmt: {
        parseAssignment();
        checkForEnd();
        break;
      }
      default: {
        wrongToken(IrType.AssignmentStmt);
      }
    }
    // System.out.println( getError() );
  }

  private void parseAssignment() {
    if (!removeToken(IrType.AssignmentStmt)) return;
    parseCall();
  }

  private void parseCall() {
    if( stream.peek().getIrType() == IrType.CallExprLinked ){
      CallExprLinked call = (CallExprLinked) stream.next();
      if( call.getFunc().getIrType() == IrType.FuncLibrary ){
        doesReturn = ((LibFunction)call.getFunc()).doesReturn();
      } else {
        doesReturn = true;
      }
      while (stream.hasNext()) {
        skipExpr();
      }
    }
  }

}
