/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.matcher;

import cfg.IrType;
import cfg.function.system.SystemFunctions;
import cfg.variable.VariableName;

public class PopMatcher extends Matcher {
  private VariableName    var;
  public PopMatcher() {
    super();
  }

  public VariableName getVariable() {
    return var;
  }

  // EBNF Variable:Id AssigmentStmt CallExpr:Pop
  protected void doParse() {
    if (stream.peek().getIrType() == IrType.AssignmentStmt) {
      parseAssignment();
    } else {
      wrongToken(IrType.AssignmentStmt);
    }
  }

  private void parseAssignment() {
    if (!removeToken(IrType.AssignmentStmt)) return;
    var = parseVarDef();
    parseCallExpr();
  }

  private void parseCallExpr() {
    if (parseFuncRefLinked(SystemFunctions.pop)) {
      checkForEnd();
    } else {
      doError("Expected", SystemFunctions.pop);
    }
  }

}
