/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.matcher;

import cfg.IrType;
import cfg.expression.VariableRef;
import cfg.function.system.SystemFunctions;
import cfg.variable.VariableName;

public class PushMatcher extends Matcher {
  private VariableName    var;

  public PushMatcher() {
    super();
  }

  public VariableName getVariable() {
    return var;
  }

  // EBNF AssigmentStmt List CallExpr:Push VariableRef:Id
  protected void doParse() {
    if (stream.peek().getIrType() == IrType.AssignmentStmt) {
      parseAssignment();
    } else {
      wrongToken(IrType.AssignmentStmt);
    }
  }

  private void parseAssignment() {
    if (!removeToken(IrType.AssignmentStmt)) return;
    parseCallExpr();
  }

  private void parseCallExpr() {
    if (parseFuncRefLinked(SystemFunctions.push)) {
      parseParamExpr();
      checkForEnd();
    } else {
      doError("Expected", SystemFunctions.push);
    }
  }

  private void parseParamExpr() {
    switch (stream.peek().getIrType()) {
      case VariableRefKilled:
      case VariableRefLinked:
      case VariableRefUnlinked: {
        var = ((VariableRef) stream.next()).getName();
        break;
      }
      default: {
        wrongToken(IrType.VariableRefUnlinked);
      }
    }
  }

}
