/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.matcher;

import cfg.IrType;
import cfg.expression.IntegerExpr;
import cfg.expression.IntegerOp;
import cfg.expression.VariableRefLinked;
import cfg.variable.Variable;

public class VarAndOffsetMatcher extends Matcher {
  private Variable var;
  private long     offset;

  public Variable getVar() {
    return var;
  }

  public long getOffset() {
    return offset;
  }

  @Override
  protected void doParse() {
    switch (stream.peek().getIrType()) {
      case IntegerExpr: {
        parseIntExpr();
        checkForEnd();
        break;
      }
      default: {
        wrongToken(IrType.IntegerExpr);
      }
    }
  }

  private void parseIntExpr() {
    IntegerOp op = ((IntegerExpr) stream.next()).getOp();

    switch (stream.peek().getIrType()) {
      case VariableRefLinked: {
        var = ((VariableRefLinked) stream.next()).getReference();
        break;
      }
      default: {
        wrongToken(IrType.VariableRefLinked);
      }
    }

    offset = parseIntConstant();

    switch (op) {
      case Add: {
        break;
      }
      case Sub: {
        offset = -offset;
        break;
      }
      default: {
        doError("Expected add or sub operand", op);
        break;
      }
    }
  }

}
