/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.matcher;

import cfg.IrType;
import cfg.variable.VariableName;

public class VarCopyMatcher extends Matcher {
  private VariableName dst;
  private VariableName src;

  public VarCopyMatcher(VariableName dst, VariableName src) {
    this.dst = dst;
    this.src = src;
  }

  public VariableName getDst() {
    return dst;
  }

  public VariableName getSrc() {
    return src;
  }

  @Override
  protected void doParse() {
    switch (stream.peek().getIrType()) {
      case AssignmentStmt: {
        parseAssignment();
        checkForEnd();
        break;
      }
      default: {
        wrongToken(IrType.AssignmentStmt);
      }
    }
//    System.out.println( getError() );
  }

  private void parseAssignment() {
    stream.next();
    if (dst != parseVarDef()) {
      doError("Expected different variable", null);
      return;
    }
    if (src != parseVarRef()) {
      doError("Expected different variable", null);
      return;
    }
  }

}
