/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.matcher;

import cfg.IrType;
import cfg.expression.IntegerExpr;
import cfg.expression.IntegerOp;
import cfg.variable.VariableName;

/**
 * Matches for and integer operation of an variable and constant, i.e.: Var IntOp Const
 * 
 * @author urs
 * 
 */
public class VarIntopConstMatcher extends Matcher {
  private VariableName var;
  private IntegerOp    op;
  private long         value;

  public IntegerOp getOp() {
    return op;
  }

  public long getValue() {
    return value;
  }

  public VariableName getVar() {
    return var;
  }

  @Override
  protected void doParse() {
    switch (stream.peek().getIrType()) {
      case IntegerExpr: {
        parseIntExpr();
        break;
      }
      case VariableRefKilled:
      case VariableRefLinked:
      case VariableRefUnlinked: {
        var = parseVarRef();
        op = IntegerOp.Add;
        value = 0;
        break;
      }
      default: {
        wrongToken(IrType.IntegerExpr);
      }
    }
    checkForEnd();
  }

  private void parseIntExpr() {
    op = ((IntegerExpr) stream.next()).getOp();
    var = parseVarRef();
    value = parseIntConstant();
  }

}
