/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.matcher;

import cfg.IrType;
import cfg.expression.IntegerExpr;
import cfg.expression.IntegerOp;
import cfg.variable.VariableName;


public class VarnameIntOpChangeMatcher extends Matcher {
  private VariableName var;
  private IntegerOp    op;
  private long         value;

  public VarnameIntOpChangeMatcher(VariableName var) {
    this.var = var;
  }

  public IntegerOp getOp() {
    return op;
  }

  public long getValue() {
    return value;
  }

  @Override
  protected void doParse() {
    switch (stream.peek().getIrType()) {
      case AssignmentStmt: {
        parseAssignment();
        checkForEnd();
        break;
      }
      default: {
        wrongToken(IrType.AssignmentStmt);
      }
    }
  }

  private void parseAssignment() {
    stream.next();
    boolean found = false;
    while( stream.peek().getIrType() == IrType.Variable ){
      if( parseVarDef() == var ){
        found = true;
      }
    }
    if (!found) {
      doError("Expected different variable (1)", null);
      return;
    }
    switch (stream.peek().getIrType()) {
      case IntegerExpr: {
        parseIntExpr();
        break;
      }
      default: {
        wrongToken(IrType.IntegerExpr);
      }
    }
  }

  private void parseIntExpr() {
    op = ((IntegerExpr) stream.next()).getOp();
    if (var != parseVarRef()) {
      doError("Expected different variable (2)", null);
      return;
    }
    value = parseIntConstant();
  }

}
