/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.statement;


import java.util.ArrayList;
import java.util.List;

import cfg.Assignable;
import cfg.IrElement;
import cfg.IrType;
import cfg.expression.Expression;
import disassembler.diStorm3.DecomposedInst;

public class AssignmentStmt extends Statement implements Assignment {
  private List<Assignable> destination;
  private Expression       source;

  public AssignmentStmt(int number, DecomposedInst original, List<Assignable> destination, Expression source) {
    super(number, original);
    this.destination = destination;
    this.source = source;
  }

  public AssignmentStmt(int number, List<Assignable> destination, Expression source) {
    super(number, null);
    this.destination = destination;
    this.source = source;
  }

  public List<Assignable> getDestination() {
    return destination;
  }

  public Expression getSource() {
    return source;
  }

  public void setSource(Expression source) {
    assert (source != null);
    this.source = source;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    if (!destination.isEmpty()) {
      boolean first = true;
      for (Assignable itr : destination) {
        if (first) {
          first = false;
        } else {
          sb.append(", ");
        }
        sb.append(itr);
      }
      sb.append(" := ");
    }
    sb.append(source);
    return sb.toString();
  }

  public IrType getIrType() {
    return IrType.AssignmentStmt;
  }

  public List<? extends IrElement> getChildren() {
    ArrayList<IrElement> res = new ArrayList<IrElement>(destination);
    res.add(source);
    return res;
  }

}
