/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.statement;


import java.util.LinkedList;
import java.util.List;

import cfg.IrElement;
import cfg.IrType;
import disassembler.diStorm3.DecomposedInst;

public class NopStmt extends Statement {

  public NopStmt(int number, DecomposedInst original) {
    super(number, original);
  }

  public NopStmt() {
    super();
  }

  @Override
  public String toString() {
    return getOriginal().toString();
  }

  public IrType getIrType() {
    return IrType.NopStmt;
  }

  public List<? extends IrElement> getChildren() {
    return new LinkedList<IrElement>();
  }
}
