/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.unlinker;

import cfg.IrTraverser;
import cfg.function.Function;
import cfg.function.PrgFunction;
import cfg.function.argument.FuncVariables;
import cfg.variable.Array;
import cfg.variable.SsaVariable;
import cfg.variable.Variable;

public class VariableRenamer extends IrTraverser<Void, Void> {
  static final private String VARNAME = "tmp";
  private int                 nr      = 0;
  private PrgFunction         func    = null;

  public static void rename(Object obj) {
    VariableRenamer renamer = new VariableRenamer();
    renamer.visit(obj, null);
  }

  @Override
  protected Void visitPrgFunction(PrgFunction obj, Void param) {
    assert (func == null);
    func = obj;
    super.visitPrgFunction(obj, param);
    assert (func == obj);
    func = null;
    return null;
  }

  @Override
  protected Void visitSsaVariable(SsaVariable obj, Void param) {
    if (!((obj.getName() instanceof FuncVariables) || func.getParam().contains(obj))) {
      rename(obj);
      obj.setVersion(0);
    }
    return null;
  }

  @Override
  protected Void visitArray(Array obj, Void param) {
    rename(obj);
    return null;
  }

  private void rename(Variable obj) {
    String name = VARNAME + Integer.toString(nr);
    nr++;
    obj.setName(new HllVariable(name));
  }

  @Override
  protected Void visitFunction(Function obj, Void param) {
    nr = 0;
    return super.visitFunction(obj, param);
  }

}
