/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.variable;


import java.util.ArrayList;
import java.util.List;

import cfg.IrElement;
import cfg.IrType;
import cfg.Memory;
import cfg.expression.Expression;

public class ArrayAccess implements Memory {
  private Expression index;
  private Array      base;

  public ArrayAccess(Array base, Expression index) {
    assert( base != null );
    assert( index != null );
    this.base = base;
    this.index = index;
  }

  public Expression getIndex() {
    return index;
  }

  public void setIndex(Expression index) {
    assert( index != null );
    this.index = index;
  }

  public Array getBase() {
    return base;
  }

  public void setBase(Array base) {
    assert( base != null );
    this.base = base;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append(base);
    sb.append("[");
    sb.append(index);
    sb.append("]");
    return sb.toString();
  }

  public IrType getIrType() {
    return IrType.VariableArray;
  }

  public List<? extends IrElement> getChildren() {
    ArrayList<IrElement> res = new ArrayList<IrElement>(2);
    res.add(index);
    return res;
  }
}
