/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.variable;


import java.util.LinkedList;
import java.util.List;

import cfg.Assignable;
import cfg.IrElement;
import cfg.IrType;

public class SsaVariable implements Variable, Assignable {

  private VariableName name;
  private int          version;

  public SsaVariable(VariableName name, int version) {
    super();
    this.name = name;
    this.version = version;
  }

  public VariableName getName() {
    return name;
  }

  public void setName(VariableName name) {
    this.name = name;
  }

  public int getVersion() {
    return version;
  }

  public void setVersion(int version) {
    this.version = version;
  }

  @Override
  public String toString() {
    return name + ":" + version;
  }

  public IrType getIrType() {
    return IrType.Variable;
  }

  public List<? extends IrElement> getChildren() {
    return new LinkedList<IrElement>();
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((name == null) ? 0 : name.hashCode());
    result = prime * result + version;
    return result;
  }

}
