/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.variable;


import java.util.ArrayList;
import java.util.List;

import cfg.IrElement;
import cfg.IrType;
import cfg.expression.Expression;

public class VariablePtrDeref extends VariableAddrCalc {
  public VariablePtrDeref(Expression expr) {
    super(expr);
  }

  @Override
  public String toString() {
    return "*" + getExpression();
  }

  public IrType getIrType() {
    return IrType.VariablePtrDeref;
  }

  public List<? extends IrElement> getChildren() {
    ArrayList<IrElement>   res = new ArrayList<IrElement>( 1 );
    res.add(getExpression());
    return res;
  }
}
