/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package codewriter;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Collection;

import util.NumPrint;
import cfg.IrTraverser;
import cfg.basicblock.BasicBlock;
import cfg.function.PrgFunction;
import cfg.statement.Statement;

public class BbWriter extends IrTraverser<Void, Writer> {

  static public void write( Collection<PrgFunction> prg, String filename ){
    BbWriter    writer = new BbWriter();
    try {
      writer.visit(prg, new Writer(new PrintStream(filename)));
    } catch (FileNotFoundException e) {
      e.printStackTrace();
    }
  }
  
  @Override
  protected Void visitPrgFunction(PrgFunction obj, Writer param) {
    param.wrln( obj.toString() + ":" );
    super.visitPrgFunction(obj, param);
    param.wrln("--------------------");
    param.wrln("");
    return null;
  }
  
  @Override
  protected Void visitBasicBlock(BasicBlock obj, Writer param) {
    param.wrln( NumPrint.toString(obj.getId()) + ":" );
    super.visitBasicBlock(obj, param);
    param.wrln("");
    return null;
  }

  @Override
  protected Void visitStatement(Statement obj, Writer param) {
    if( !obj.isDeleted() ){
      param.wrln(obj);
    }
    return null;
  }

}
