/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package codewriter;

import java.util.List;
import java.util.Map;

import ast.statement.Statement;
import ast.variable.Variable;

public class LiveInfo implements InfoWriter {
  private final Map<Statement, List<Variable>> live;

  public LiveInfo(Map<Statement, List<Variable>> live) {
    this.live = live;
  }

  public String get(Statement obj) {
    if (live.containsKey(obj)) {
      return live.get(obj).toString();
    } else {
      return "";
    }
  }

}
