/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package codewriter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;

public class SupportWriter {
  public static void generateFiles(String path) {
    try {

      {
        PrintStream stream = new PrintStream(path + File.separator + "Main.java");
        Writer writer = new Writer(stream);
        generateMain(writer);
        stream.close();
      }

      {
        PrintStream stream = new PrintStream(path + File.separator + "IoSupport.java");
        Writer writer = new Writer(stream);
        generateIoSupport(writer);
        stream.close();
      }
      {
        PrintStream stream = new PrintStream(path + File.separator + "Pointer.java");
        Writer writer = new Writer(stream);
        generatePointer(writer);
        stream.close();
      }
    } catch (FileNotFoundException e) {
      e.printStackTrace();
    }
  }

  private static void generatePointer(Writer wr) {
    wr.wrln("import java.util.ArrayList;");
    wr.nl();
    wr.wrln("public class Pointer<T> {");
    wr.wrln("  private ArrayList<T> memory;");
    wr.wrln("  private int          position = 0;");
    wr.nl();
    wr.wrln("  public Pointer(int n) {");
    wr.wrln("    memory = new ArrayList<T>(n);");
    wr.wrln("    for (int i = 0; i < n; i++) {");
    wr.wrln("      memory.add(null);");
    wr.wrln("    }");
    wr.wrln("  }");
    wr.nl();
    wr.wrln("  public Pointer(Pointer<T> old, int displacement) {");
    wr.wrln("    memory = old.memory;");
    wr.wrln("    position = old.position + displacement;");
    wr.wrln("  }");
    wr.nl();
    wr.wrln("  public void free() {");
    wr.wrln("    memory.clear();");
    wr.wrln("  }");
    wr.nl();
    wr.wrln("  public T getValue(int offset) {");
    wr.wrln("    return memory.get(position + offset);");
    wr.wrln("  }");
    wr.nl();
    wr.wrln("  public void setValue(int offset, T value) {");
    wr.wrln("    memory.set(position + offset, value);");
    wr.wrln("  }");
    wr.wrln("}");
  }

  private static void generateIoSupport(Writer wr) {
    wr.wrln("import java.util.Scanner;");
    wr.nl();
    wr.wrln("public class IoSupport {");
    wr.wrln("  private static Scanner s   = new Scanner(System.in);");
    wr.nl();
    wr.wrln("  public static int readInt() {");
    wr.wrln("    return s.nextInt();");
    wr.wrln("  }");
    wr.nl();
    wr.wrln("  public static void writeStr(String string) {");
    wr.wrln("    System.out.print(string);");
    wr.wrln("  }");
    wr.nl();
    wr.wrln("  public static void writeNl() {");
    wr.wrln("    System.out.println();");
    wr.wrln("  }");
    wr.nl();
    wr.wrln("  public static void writeInt(int value) {");
    wr.wrln("    System.out.print(value);");
    wr.wrln("  }");
    wr.wrln("}");
  }

  private static void generateMain(Writer wr) {
    wr.wrln("public class Main {");
    wr.wrln("  public static void main(String[] args) {");
    wr.wrln("    UserPrg user = new UserPrg();");
    wr.wrln("    System.exit(user.main());");
    wr.wrln("  }");
    wr.wrln("}");
  }

}
