/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package dataflow;

import java.util.Collection;


public class AstBlock<V> implements DfVertex<V> {
  private Collection<V> def;
  private Collection<V> use;
  private Collection<V> kill;

  public AstBlock(Collection<V> def, Collection<V> use, Collection<V> kill) {
    super();
    this.def = def;
    this.use = use;
    this.kill = kill;
  }

  public final Collection<V> getDef() {
    return def;
  }

  public final Collection<V> getUse() {
    return use;
  }

  public final Collection<V> getKill() {
    return kill;
  }

}
