/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package dataflow.copyprop;

import java.util.HashSet;
import java.util.Set;

import util.Pair;
import ast.PrgFunc;
import ast.expression.Expression;
import ast.statement.AssignmentStmt;
import ast.statement.CallStmt;
import ast.statement.CaseStmt;
import ast.statement.DoWhile;
import ast.statement.IfStmt;
import ast.statement.NullStmt;
import ast.statement.RetStmt;
import ast.statement.VarDef;
import ast.statement.WhileStmt;
import ast.traverser.VariableAccessCollector;
import ast.variable.Variable;
import ast.variable.VariableRefLinked;
import dataflow.AstBlock;
import dataflow.GraphBuilder;

public class CopyPropGb extends GraphBuilder<Pair<Variable, Variable>> {
  private final Set<Pair<Variable, Variable>> empty = new HashSet<Pair<Variable, Variable>>();

  protected Set<Pair<Variable, Variable>> getVarRef(Expression expr) {
    VariableAccessCollector collector = new VariableAccessCollector();
    collector.visit(expr, null);
    
    Set<Pair<Variable, Variable>> res = new HashSet<Pair<Variable,Variable>>();
    for( Variable var : collector.getReferenced() ){
      res.add( new Pair<Variable, Variable>(null, var) );
    }
    return res ;
  }

  @Override
  protected AstBlock<Pair<Variable, Variable>> createVertex(AssignmentStmt obj) {
    Set<Pair<Variable, Variable>> kill = getVarRef(obj.getDestination());
    Set<Pair<Variable, Variable>> def = new HashSet<Pair<Variable, Variable>>();
    if ((obj.getSource() instanceof VariableRefLinked) && (obj.getDestination() instanceof VariableRefLinked)) {
      VariableRefLinked dst = (VariableRefLinked) obj.getDestination();
      VariableRefLinked src = (VariableRefLinked) obj.getSource();
      def.add(new Pair<Variable, Variable>(dst.getReference(), src.getReference()));
    }
    return new AstBlock<Pair<Variable, Variable>>(def, getVarRef(obj.getSource()), kill);
  }

  @Override
  protected AstBlock<Pair<Variable, Variable>> createVertex(PrgFunc obj) {
    Set<Pair<Variable, Variable>> res = new HashSet<Pair<Variable,Variable>>();
    for( Variable var : obj.getParam() ){
      res.add( new Pair<Variable, Variable>(var,null) );
    }
    return new AstBlock<Pair<Variable, Variable>>(res, empty, empty);
  }

  @Override
  protected AstBlock<Pair<Variable, Variable>> createVertex() {
    return new AstBlock<Pair<Variable, Variable>>(empty, empty, empty);
  }

  @Override
  protected AstBlock<Pair<Variable, Variable>> createVertex(NullStmt obj) {
    return new AstBlock<Pair<Variable, Variable>>(empty, empty, empty);
  }

  @Override
  protected AstBlock<Pair<Variable, Variable>> createVertex(VarDef obj) {
    return new AstBlock<Pair<Variable, Variable>>(empty, empty, empty);
  }

  @Override
  protected AstBlock<Pair<Variable, Variable>> createVertex(CallStmt obj) {
    return new AstBlock<Pair<Variable, Variable>>(empty, getVarRef(obj.getCall()), empty);
  }

  @Override
  protected AstBlock<Pair<Variable, Variable>> createVertex(RetStmt obj) {
    return new AstBlock<Pair<Variable, Variable>>(empty, getVarRef(obj.getRetval()), empty);
  }

  @Override
  protected AstBlock<Pair<Variable, Variable>> createVertex(IfStmt obj) {
    return new AstBlock<Pair<Variable, Variable>>(empty, getVarRef(obj.getCondition()), empty);
  }

  @Override
  protected AstBlock<Pair<Variable, Variable>> createVertex(CaseStmt obj) {
    return new AstBlock<Pair<Variable, Variable>>(empty, getVarRef(obj.getCondition()), empty);
  }

  @Override
  protected AstBlock<Pair<Variable, Variable>> createVertex(WhileStmt obj) {
    return new AstBlock<Pair<Variable, Variable>>(empty, getVarRef(obj.getCondition()), empty);
  }

  @Override
  protected AstBlock<Pair<Variable, Variable>> createVertex(DoWhile obj) {
    return new AstBlock<Pair<Variable, Variable>>(empty, getVarRef(obj.getCondition()), empty);
  }

}
