/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package dataflow.copyprop;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.jgrapht.DirectedGraph;

import util.Pair;
import dataflow.DataFlowLooper;
import dataflow.DfVertex;

public class CopyPropagation<V, E> extends DataFlowLooper<Pair<V,V>, E> {

  public CopyPropagation(DirectedGraph<DfVertex<Pair<V,V>>, E> graph) {
    super(graph);
  }

  protected boolean processBlock(DfVertex<Pair<V,V>> n) {
    boolean change = false;
    { // out
      Set<Pair<V,V>> outn = new HashSet<Pair<V,V>>( in.get(n) );
      for( Pair<V,V> itr : in.get(n) ){
        for( Pair<V,V> kill : n.getKill() ){
          assert( kill.getFirst() == null );
          if( itr.getFirst().equals(kill.getSecond()) || itr.getSecond().equals(kill.getSecond()) ){
            outn.remove(itr);
          }
        }
      }
      outn.addAll(n.getDef());
      change = change || !out.get(n).equals(outn);
      out.put(n, outn);
    }

    { // in
      Set<Pair<V,V>> ins = new HashSet<Pair<V,V>>();
      List<E> list = new ArrayList<E>(graph.incomingEdgesOf(n));
      if (!list.isEmpty()) {
        {
          DfVertex<Pair<V,V>> p = graph.getEdgeSource(list.get(0));
          Set<Pair<V,V>> outp = out.get(p);
          ins.addAll(outp);
        }
        for (E e : list) {
          DfVertex<Pair<V,V>> p = graph.getEdgeSource(e);
          Set<Pair<V,V>> outp = out.get(p);
          ins.retainAll(outp);
        }
      }
      change = change || !in.get(n).equals(ins);
      in.put(n, ins);
    }
    return change;
  }

  protected void init() {
    for (DfVertex<Pair<V,V>> s : graph.vertexSet()) {
      in.put(s, new HashSet<Pair<V,V>>());
      out.put(s, new HashSet<Pair<V,V>>());
    }
  }

}
