/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package dataflow.livevar;

import java.util.HashSet;
import java.util.Set;

import org.jgrapht.DirectedGraph;

import dataflow.DataFlowLooper;
import dataflow.DfVertex;

// following more or less https://en.wikipedia.org/wiki/Liveness_analysis
// T is the objects we work on, mostly variables
// V are vertexes, probably statements or basic blocks
// E are edges between V
public class LiveVariableAlgo<V, E> extends DataFlowLooper<V, E> {

  public LiveVariableAlgo(DirectedGraph<DfVertex<V>, E> graph) {
    super(graph);
  }

  protected boolean processBlock(DfVertex<V> s) {
    { // out
      Set<V> outs = new HashSet<V>();
      for (E e : graph.outgoingEdgesOf(s)) {
        DfVertex<V> p = graph.getEdgeTarget(e);
        Set<V> inp = in.get(p);
        outs.addAll(inp);
      }
      out.put(s, outs);
    }

    boolean change;
    { // in
      Set<V> ins = new HashSet<V>(out.get(s));
      ins.removeAll(s.getDef());
      ins.addAll(s.getUse());
      change = !in.get(s).equals(ins);
      in.put(s, ins);
    }
    return change;
  }

  protected void init() {
    for (DfVertex<V> s : graph.vertexSet()) {
      in.put(s, new HashSet<V>());
      out.put(s, new HashSet<V>());
    }
  }

}
