package disassembler.diStorm3;

import java.io.PrintStream;

import util.NumPrint;

public class DecomposedInst {
	public class ImmVariant {
		private long mValue;
		private int mSize;

		public long getImm() {
			return mValue;
		}

		public int getSize() {
			return mSize;
		}
	}

	public class DispVariant {

		private long mDisplacement;
		private int mSize;

		public long getDisplacement() {
			return mDisplacement;
		}

		public int getSize() {
			return mSize;
		}
	}

	private long mAddr;
	private int mSize;
	@SuppressWarnings("unused")
	private int mFlags;
	private int mSegment;
	private int mBase, mScale;
	private int mOpcode;
	public Operand[] mOperands;
	public DispVariant mDisp;
	public ImmVariant mImm;
	private int mUnusedPrefixesMask;
	private int mMeta;
	private int mRegistersMask;

	public long getAddress() {
		return mAddr;
	}
	public int getSize() {
		return mSize;
	}
	public OpcodeEnum getOpcode() {
		return OpcodeEnum.fromInt(mOpcode);
	}
	public int getSegment() {
		return mSegment & 0x7f;
	}
	public boolean isSegmentDefault() {
		return (mSegment & 0x80) == 0x80;
	}
	public int getBase() {
		return mBase;
	}
	public int getScale() {
		return mScale;
	}
	public int getUnusedPrefixesMask() {
		return mUnusedPrefixesMask;
	}
	public int getMeta() {
		return mMeta;
	}
	public int getRegistersMask() {
		return mRegistersMask;
	}
	public void dump(PrintStream stream) {
		stream.println(getOpcode());
	}

	//@override
	public String toString(){
		String	res;
		
		res = NumPrint.toString(mAddr) + ":\t";
		res += getOpcode().toString();
/*		while( res.length() < 8 ){
			res += " ";
		}*/
		res += "\t";
		
		for( Operand op : mOperands ){
			res += op.getPretty( this );
			res += ", ";
		}
		
		
		return res;
	}
	
	//TODO check if correct, needs probably better analysis
	public boolean isConstant(){
		for( Operand op : mOperands ){
			switch(op.getType()){
			case Disp:
			case Mem:
			case None:
			case Ptr:
			case Reg:
			case Smem:
				return false;
			}
		}
		return true;
	}
	public long getConstantValue(){
		long res = mImm.mValue + mDisp.mDisplacement;
		for( Operand op : mOperands ){
			switch(op.getType()){
/*			case Imm:
			case Imm1:
			case Imm2:
				res += mImm.mValue;
				break;*/
			case Pc:
				res += mAddr + mSize;
				break;
			default:
				throw new RuntimeException( "Only addresses implemented: " + this );
			}
		}
		return res;
	}
}
