package disassembler.diStorm3;


import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

import cfg.Flags;

public enum OpcodeEnum {
	UNDEFINED(0), SLDT(0x66e), POPA(0x62), UNPCKHPS(0x8eb), POPF(0x115), CMPLTSS(
			0x117d), VMOVSD(0x84a), PFPNACC(0x786), VMOVMSKPD(0xb11), INVLPGA(
			0x734), UNPCKHPD(0x8f5), SYSEXIT(0x270), PFSUB(0x7af), CMPLTSD(
			0x11cc), VPMULHUW(0x1535), VMOVSS(0x842), ARPL(0x6f), FICOMP(0x52f), RETF(
			0x162), FCHS(0x452), CMPLEPS(0x10e8), PUNPCKHDQ(0xeef), FUCOM(0x5f3), VCMPORDPS(
			0x125e), PSUBUSW(0x1483), PMAXUD(0x1afb), VPABSB(0x18e9), WRMSR(
			0x24a), VFMADDSUB231PD(0x1d87), PFMAX(0x7c6), VFNMADD213PD(0x1d15), MOVNTI(
			0x3bd), PFCMPGT(0x7bd), VFNMADD231SS(0x1e3b), PEXTRB(0x1fa7), VRCPSS(
			0xb94), VFMSUB213PD(0x1ce0), VPHADDSW(0x17c1), VPSLLDQ(0x2147), PFCMPGE(
			0x78f), CVTDQ2PD(0x155b), CMPLESD(0x11d5), JNS(0xae), VDIVSD(0xdd5), JNP(
			0xb7), XAVE(0x1093), PMOVZXBQ(0x1a1d), JNZ(0x9c), FCOMI(0x5dd), VPUNPCKHWD(
			0xee3), PMOVZXBD(0x1a08), VMOVNTDQ(0x15a2), PMOVSXWD(0x194e), POPCNT(
			0x10c2), JNO(0x8a), FNSAVE(0x1767), LOOP(0x1a5), VMOVMSKPS(0xb06), FLDL2T(
			0x470), CMPS(0x12d), FSUB(0x40d), DIVPS(0xda1), PHSUBD(0x17f3), CMPEQSS(
			0x1174), CMC(0x1e7), CVTTPS2DQ(0xcfc), DIVPD(0xda8), VMOVD(0xf59), CALL_FAR(
			0x104), PMULHRSW(0x184a), VPMULHRSW(0x1854), PHSUBW(0x17e2), CMPEQSD(
			0x11c3), XADD(0x3b7), CMOVBE(0x2ae), CMP(0x47), SBB(0x24), VHADDPS(
			0x1057), INVVPID(0x1b3e), LSL(0x20f), VHADDPD(0x104e), LSS(0x38b), VFMSUB132PD(
			0x1bc8), LAHF(0x121), PFACC(0x7e9), PFRCPIT2(0x800), VPUNPCKLBW(
			0xe24), PFRCPIT1(0x7cd), PCMPGTQ(0x1a71), FYL2X(0x4a4), PSRLD(
			0x140b), SFENCE(0x10b1), CVTPS2DQ(0xcf2), PBLENDW(0x1f80), VFMSUBADD213PS(
			0x1c7f), VPINSRB(0x200b), PCMPGTB(0xe73), PCMPGTD(0xe99), VAESENC(
			0x1ea8), VMOVSHDUP(0x954), MPSADBW(0x2065), VAESDEC(0x1ed2), VMMCALL(
			0x707), INSERTQ(0x102c), VFNMADD213SS(0x1d23), CVTPI2PD(0x9bc), INT(
			0x16f), VPERMILPS(0x185f), HLT(0x1e2), PHMINPOSUW(0x1b1d), FCMOVNU(
			0x5b6), INS(0x7b), FCOMIP(0x64c), CVTPI2PS(0x9b2), VFNMADD213SD(
			0x1d31), PACKUSWB(0xeac), CBW(0xe4), VMSAVE(0x718), PUSHF(0x10e), NOT(
			0x654), FCMOVNB(0x59a), NOP(0x245), FSQRT(0x4ed), VPERMILPD(0x186a), INC(
			0x51), UD2(0x239), VPCMPEQW(0xfe4), PCMPISTRM(0x20dd), VPCMPEQQ(
			0x19a7), CMPNLEPS(0x1111), VCMPUNORDPD(0x1287), FADDP(0x602), RET(
			0x145), VPCMPEQD(0xff7), VPCMPEQB(0xfd1), ADDSUBPD(0x13d2), VFMADDSUB231PS(
			0x1d77), VPAVGB(0x14f7), PSIGNW(0x1828), VPMOVSXDQ(0x1982), VPMAXSD(
			0x1ae1), SETG(0x35b), VPMAXSB(0x1ad0), SETA(0x327), SETB(0x306), STMXCSR(
			0x2163), SETL(0x347), VFMSUB132PS(0x1bbb), SETO(0x2f9), ANDNPD(
			0xbca), BSR(0x10ca), VMOVDDUP(0x8b7), VPMAXSW(0x1614), PSIGND(
			0x1839), SETP(0x33a), PSIGNB(0x1817), LFS(0x395), SETS(0x32d), VCMPUNORDSS(
			0x12de), BSF(0x3ab), VMXON(0x2188), VANDPS(0xbb2), XSETBV(0x6f8), OUT(
			0x1c3), LTR(0x67f), VPINSRD(0x2039), VCVTTSS2SI(0xa54), VPSRLDQ(
			0x2136), FDECSTP(0x4cb), PSRLDQ(0x212e), PSLLDQ(0x213f), FCOS(0x514), FXTRACT(
			0x4ba), VMOVNTDQA(0x19bb), FMUL(0x3fa), FCOMPP(0x610), PF2ID(0x777), CWD(
			0xf5), CMOVLE(0x2ea), VPSHUFHW(0xfb4), VCMPEQSS(0x12c0), PHADDSW(
			0x17b8), PF2IW(0x770), VMOVNTPD(0xa1e), FCOMP(0x406), UNPCKLPS(
			0x8c1), MASKMOVDQU(0x16a7), FCMOVBE(0x565), VMAXSD(0xe11), VCMPNLTPD(
			0x129f), PREFETCHT2(0x984), PREFETCHT1(0x978), PREFETCHT0(0x96c), UNPCKLPD(
			0x8cb), CVTTSS2SI(0xa3e), DIV(0x663), PMOVSXDQ(0x1978), VPMINSD(
			0x1a9d), CDQE(0xef), VSTMXCSR(0x216c), FISUBR(0x53e), VPMINSB(
			0x1a8c), VFMSUB213PS(0x1cd3), CMPLESS(0x1186), VPMINSW(0x15d6), FSTENV(
			0x1732), VPTEST(0x18ae), FISUB(0x537), STD(0x205), VPACKSSDW(0xf10), XOR(
			0x3d), VMULPD(0xc7c), STC(0x1f1), STI(0x1fb), LDMXCSR(0x2150), CMPLTPD(
			0x112e), ORPS(0xbe4), VPACKUSDW(0x19d0), FSUBP(0x620), STR(0x674), FSUBR(
			0x413), CMPLTPS(0x10df), VFMADD231SD(0x1dde), PAUSE(0x219d), CVTPD2DQ(
			0x1565), RSM(0x372), VSQRTSD(0xb45), VORPS(0xbf0), VFMADDSUB213PS(
			0x1c5f), AESENC(0x1ea0), VUNPCKHPS(0x8ff), PMADDUBSW(0x17cb), VPSLLW(
			0x1640), MASKMOVQ(0x169d), CALL(0x1c8), VSQRTSS(0xb3c), PADDUSB(
			0x14b4), VMREAD(0x101d), VUNPCKHPD(0x90a), VSUBPS(0xd45), VCVTSS2SD(
			0xcbc), VPBLENDVW(0x1f89), VAESDECLAST(0x1ee7), HSUBPS(0x1068), VCVTSS2SI(
			0xa94), VPBLENDVB(0x20a5), MOVNTDQA(0x19b1), FILD(0x57f), VCOMISS(
			0xae0), HSUBPD(0x1060), VFNMSUB231SS(0x1e73), VPSRAD(0x1515), VCMPNLEPS(
			0x1253), SAL(0x3ea), SYSCALL(0x214), VRSQRTSS(0xb72), VPINSRQ(
			0x2042), VPSHUFD(0xfab), PMOVSXBW(0x190f), VPSRAW(0x1506), VCMPNLEPD(
			0x12aa), FADD(0x3f4), SAR(0x3ef), MOVNTQ(0x1591), AESKEYGENASSIST(
			0x210b), PACKSSDW(0xf06), VFMADD213SS(0x1cb9), VMOVDQA(0xf77), VMOVSLDUP(
			0x8ac), FRNDINT(0x4fd), PMULLW(0x1438), DIVSD(0xdb6), MOVMSKPS(
			0xaf2), VPMAXUW(0x1af2), VDIVPD(0xdc5), VPMOVSXBW(0x1919), PMOVSXWQ(
			0x1963), PMULLD(0x1b0c), VMOVDQU(0xf80), CMOVAE(0x297), VDIVPS(
			0xdbd), JAE(0x93), MOVMSKPD(0xafc), DIVSS(0xdaf), VAESIMC(0x1e97), PCMPEQQ(
			0x199e), VPSHUFLW(0xfbe), PCMPEQW(0xfdb), VLDMXCSR(0x2159), VFMSUB132SS(
			0x1bd5), CMPORDPD(0x116a), RCPSS(0xb8d), VPSLLD(0x164f), IDIV(0x668), VCMPORDPD(
			0x12b5), PCMPEQB(0xfc8), PCMPEQD(0xfee), VPSLLQ(0x165e), VPMOVZXBQ(
			0x1a27), VFMSUBADD213PD(0x1c8f), VBLENDVPD(0x209a), CMPORDPS(0x111b), PUNPCKLQDQ(
			0xf1b), VPAND(0x14ad), VPHADDW(0x179e), HADDPD(0x103e), VADDSUBPS(
			0x13f1), VSHUFPD(0x13a9), VSUBSD(0xd5d), VSQRTPS(0xb4e), MOVSHDUP(
			0x92e), VFNMADD231SD(0x1e49), VMLAUNCH(0x6c4), VMASKMOVPD(0x19e7), HADDPS(
			0x1046), PUNPCKLWD(0xe30), VSQRTPD(0xb57), VSUBSS(0xd55), VSHUFPS(
			0x13a0), VCMPNEQSS(0x12eb), VLDDQU(0x1631), PADDSW(0x15fb), ORPD(
			0xbea), PMINSD(0x1a95), FPTAN(0x4ab), FIDIV(0x546), PXOR(0x161d), VMPTRLD(
			0x2176), VFMSUB231PS(0x1deb), VCMPNEQSD(0x1342), VPMULDQ(0x1995), LOOPNZ(
			0x196), VCMPUNORDPS(0x1230), SHR(0x3e5), SHRD(0x37c), MONITOR(0x6e0), VPTESTPS(
			0x1875), AESENCLAST(0x1eb1), MOVSD(0x83b), VPINSRW(0x1376), VMLOAD(
			0x710), MOVLHPS(0x915), VMOVLPD(0x8a3), MOVQ2DQ(0x1449), SQRTSS(
			0xb2c), VDPPS(0x2051), SUBSS(0xd37), MOVSX(0x3b0), VMOVLHPS(0x938), VMOVLPS(
			0x89a), VPUNPCKHDQ(0xefa), VCVTPD2DQ(0x1586), SHL(0x3e0), MOVSS(
			0x834), PINSRQ(0x2031), PFNACC(0x77e), MOVDQU(0xf6f), OUTS(0x80), PSUBB(
			0x16c0), BTS(0x377), BTR(0x390), SGDT(0x690), VFMADD231SS(0x1dd1), FSCALE(
			0x506), PSUBW(0x16cf), CMPNLTPD(0x1156), PACKUSDW(0x19c6), LAR(
			0x20a), BTC(0x3a6), VFNMADD132SD(0x1c19), EXTRACTPS(0x1fd1), VPMOVZXBW(
			0x19fd), VFMSUB132SD(0x1be2), AESIMC(0x1e8f), FCOM(0x400), VPMOVZXBD(
			0x1a12), VADDSUBPD(0x13e6), CMPORDSS(0x11b9), WBINVD(0x231), PAND(
			0x14a7), VPALIGNR(0x1f9d), CMPORDSD(0x1208), VPXOR(0x1623), JBE(
			0xa1), FXAM(0x464), MUL(0x65e), FSAVE(0x176f), VPADDSW(0x1603), PMAXSW(
			0x160c), VINSERTPS(0x201e), VCMPEQPD(0x1269), FFREE(0x5ec), VMASKMOVPS(
			0x19db), CMPXCHG8B(0x13b2), PMAXSD(0x1ad9), VPTESTPD(0x187f), VPADDSB(
			0x15f2), PUSH(0x10), VPCLMULQDQ(0x2083), VCMPEQPS(0x1212), PFRSQIT1(
			0x7d7), ROUNDPS(0x1f0e), SETNO(0x2ff), XGETBV(0x6f0), ROUNDPD(
			0x1f21), PADDB(0x16fc), FPREM1(0x4c3), CLD(0x200), FIMUL(0x521), XORPD(
			0xc05), CLC(0x1ec), FSTP(0x431), BLENDPD(0x1f6d), PADDUSW(0x14c7), FNINIT(
			0x1758), SETNZ(0x319), PADDQ(0x1429), XORPS(0xbfe), SETNS(0x333), FIADD(
			0x51a), SETNP(0x340), VPUNPCKHQDQ(0xf40), SUBPS(0xd29), CMPNLTSD(
			0x11f4), LLDT(0x679), VFMSUB213SD(0x1cfa), PTEST(0x18a7), VFNMSUB132PD(
			0x1c35), GETSEC(0x279), VPSIGND(0x1841), JCXZ(0x1ab), CMPNLTSS(
			0x11a5), SETGE(0x34d), CMPEQPS(0x10d6), PSADBW(0x168c), MOVSXD(
			0x2195), VFNMSUB132PS(0x1c27), AAD(0x185), VAESENCLAST(0x1ebd), PUNPCKHQDQ(
			0xf34), MOVLPD(0x875), VPADDUSW(0x14bd), AAM(0x180), VPUNPCKLQDQ(
			0xf27), MINSS(0xd73), PADDD(0x171a), VPUNPCKLWD(0xe3b), MOVLPS(
			0x86d), CLGI(0x726), AAS(0x4c), LODS(0x139), CMOVNP(0x2d3), MINSD(
			0xd7a), CLI(0x1f6), CVTTSD2SI(0xa49), FICOM(0x528), PMOVZXBW(0x19f3), ADDPD(
			0xc23), PREFETCHW(0x757), VXORPD(0xc14), POR(0x15df), POP(0x16), VPERM2F128(
			0x1f02), LOOPZ(0x19e), MOVNTDQ(0x1599), INT1(0x1dc), CMPXCHG(0x382), VBROADCASTF128(
			0x18d2), VPMADDUBSW(0x17d6), PHADDW(0x1796), VXORPS(0xc0c), ADDPS(
			0xc1c), PFMUL(0x7f9), LGDT(0x69c), VERR(0x684), VERW(0x68a), VHSUBPD(
			0x1070), VMOVUPS(0x852), INTO(0x174), FCLEX(0x1751), VHSUBPS(0x1079), CVTSD2SS(
			0xcb2), FLDPI(0x480), PABSW(0x18f1), VMAXPD(0xe01), JMP_FAR(0x1d3), VPACKUSWB(
			0xeb6), FUCOMPP(0x576), VMOVUPD(0x85b), PSWAPD(0x813), PADDW(0x170b), PSLLD(
			0x1648), SWAPGS(0x73d), MOVSLDUP(0x87d), CVTSI2SS(0x9c6), CMPUNORDSS(
			0x118f), VCVTTPS2DQ(0xd1d), SQRTSD(0xb34), PSUBD(0x16de), TEST(0xce), LGS(
			0x39a), SYSENTER(0x266), CVTSI2SD(0x9d0), VCMPNLESD(0x1358), VFNMADD132SS(
			0x1c0b), JZ(0x98), VDIVSS(0xdcd), VORPD(0xbf7), JP(0xb3), JS(0xaa), JL(
			0xbc), RSQRTSS(0xb69), JO(0x86), VMAXPS(0xdf9), PSUBUSB(0x1470), JG(
			0xca), VBROADCASTSS(0x18b6), JA(0xa6), JB(0x8f), CWDE(0xe9), VCMPLEPD(
			0x127d), VMWRITE(0x1035), VCMPLEPS(0x1226), PMOVMSKB(0x145b), INSERTPS(
			0x2014), PCMPESTRI(0x20c7), WAIT(0x218f), VBROADCASTSD(0x18c4), PCMPESTRM(
			0x20b0), PUNPCKLDQ(0xe47), MULSS(0xc66), VSUBPD(0xd4d), CMPEQPD(
			0x1125), VCOMISD(0xae9), VMINSS(0xd91), VPADDD(0x1721), RDMSR(0x258), VPSIGNW(
			0x1830), JECXZ(0x1b1), MULSD(0xc6d), ENTER(0x154), MOVBE(0x1ef4), VZEROALL(
			0x1013), VMINSD(0xd99), PFSUBR(0x7e1), AESDECLAST(0x1edb), VPSUBUSB(
			0x1479), VFMSUB231SD(0x1e12), FXSAVE(0x1082), FISTTP(0x585), PANDN(
			0x14e1), BLENDPS(0x1f5a), VCMPLESD(0x132b), FCMOVNBE(0x5ac), VFMSUB231SS(
			0x1e05), VBLENDVPS(0x208f), VMPSADBW(0x206e), VPSUBUSW(0x148c), VCMPLTSD(
			0x1321), SHUFPD(0x1398), SUBPD(0xd30), SQRTPD(0xb24), VMOVHPD(0x94b), VMCALL(
			0x6bc), VFMADD132PD(0x1b94), LEAVE(0x15b), SHUFPS(0x1390), VCMPLTSS(
			0x12ca), VPCMPESTRM(0x20bb), VFMADD132PS(0x1b87), LIDT(0x6a2), F2XM1(
			0x49d), VMOVHPS(0x942), PMOVZXDQ(0x1a5c), VZEROUPPER(0x1007), SQRTPS(
			0xb1c), VANDNPS(0xbd2), VPADDQ(0x1430), FPREM(0x4dd), VPADDW(0x1712), PALIGNR(
			0x1f94), PMINSB(0x1a84), PCMPGTW(0xe86), SHLD(0x36c), LDS(0x14f), VPADDB(
			0x1703), VMRUN(0x700), VANDNPD(0xbdb), XLAT(0x190), XCHG(0xd4), FINCSTP(
			0x4d4), MOVDQ2Q(0x1452), PMINSW(0x15ce), SMSW(0x6a8), VPSIGNB(
			0x181f), XRSTOR(0x10a1), VBLENDPD(0x1f76), JGE(0xc0), VCMPORDSD(
			0x1363), VBLENDPS(0x1f63), FTST(0x45e), CVTTPD2DQ(0x1550), VCMPORDSS(
			0x130c), VCMPESTRI(0x20d2), VFNMSUB132SS(0x1c43), AND(0x29), VRSQRTPS(
			0xb7c), CLFLUSH(0x10b9), PSHUFB(0x1785), FLDENV(0x437), MOV(0xda), PSHUFD(
			0xf91), JLE(0xc5), FEDISI(0x5c5), VPCMPGTW(0xe8f), PFCMPEQ(0x7f0), PSHUFW(
			0xf89), VPEXTRB(0x1faf), VCVTDQ2PD(0x157b), VMOVQ(0xf60), FLDL2E(
			0x478), VPEXTRD(0x1fc8), VPHSUBW(0x17ea), VFNMSUB213PS(0x1d3f), VFMADD213PD(
			0x1cac), STGI(0x720), FPATAN(0x4b2), FST(0x42c), INT_3(0x168), FIST(
			0x58d), VMCLEAR(0x217f), PMOVSXBQ(0x1939), AAA(0x42), VPHSUBD(
			0x17fb), CVTTPS2PI(0xa28), CMPNEQPS(0x10fd), LDDQU(0x162a), RSQRTPS(
			0xb60), VADDPD(0xc40), PFRCP(0x79f), CVTSS2SD(0xca8), VFNMSUB132SD(
			0x1c51), FDIVRP(0x627), FBLD(0x636), CPUID(0x361), RDTSC(0x251), VCVTPS2DQ(
			0xd12), VPOR(0x15e4), VADDPS(0xc38), PI2FW(0x762), MINPS(0xd65), VPMULUDQ(
			0x166f), MAXSD(0xdf2), VPMULLD(0x1b14), FIDIVR(0x54d), VUCOMISS(
			0xabc), MOVDDUP(0x887), VPSHUFB(0x178d), VPCMPISTRI(0x20ff), MAXSS(
			0xdeb), VPMULLW(0x1440), MINPD(0xd6c), FYL2XP1(0x4e4), VUCOMISD(
			0xac6), VFNMSUB231PD(0x1e65), ADDSD(0xc31), VMXOFF(0x6d8), PSRLQ(
			0x141a), VCMPNEQPS(0x123d), PSRLW(0x13fc), SIDT(0x696), PACKSSWB(
			0xe5e), VCMPNEQPD(0x1294), CDQ(0xfa), ADDSS(0xc2a), VFNMSUB213SS(
			0x1d5b), CRC32(0x1efb), PMAXSB(0x1ac8), VEXTRACTPS(0x1fdc), VPSUBB(
			0x16c7), VPMOVZXWQ(0x1a51), MOVNTSS(0xa02), VEXTRACTF128(0x1ff5), PADDSB(
			0x15ea), IMUL(0x75), RCR(0x3db), FINIT(0x1760), RCL(0x3d6), MOVNTSD(
			0xa0b), SUBSD(0xd3e), SCAS(0x13f), PCLMULQDQ(0x2078), PFRSQRT(0x7a6), PINSRD(
			0x2029), FSUBRP(0x618), PUSHA(0x5b), VPMAXUB(0x14d8), CMPUNORDPS(
			0x10f1), VPMAXUD(0x1b03), FABS(0x458), VPMOVSXBQ(0x1943), FEMMS(
			0x23e), VFMADD213SD(0x1cc6), VPMOVSXBD(0x192e), CMPUNORDPD(0x1140), VMPTRST(
			0x13c9), CMPXCHG16B(0x13bd), FNCLEX(0x1749), CMPNEQSD(0x11ea), FCMOVU(
			0x56e), EXTRQ(0x1025), DPPD(0x2058), CMOVGE(0x2e2), PINSRB(0x2003), VFNMSUB213SD(
			0x1d69), CMPNEQSS(0x119b), VFMADD231PD(0x1dc4), FSIN(0x50e), IN(
			0x1bf), FCMOVE(0x55d), FLDCW(0x43f), DPPS(0x204b), FCMOVB(0x555), VPSRLW(
			0x1403), LFENCE(0x1099), CVTSD2SI(0xa8a), SETAE(0x30c), CMOVNZ(
			0x2a6), VPSRLQ(0x1421), FMULP(0x609), VMOVAPD(0x9a9), CMOVNS(0x2c4), FCMOVNE(
			0x5a3), CMOVNO(0x288), VPMULHW(0x1547), VPSRLD(0x1412), CVTPS2PI(
			0xa6c), PHADDD(0x17a7), CVTPS2PD(0xc94), VPABSW(0x18f8), VMOVAPS(
			0x9a0), VPSUBW(0x16d6), PMULHRW(0x80a), MOVAPS(0x990), PFMIN(0x798), MOVD(
			0xf4d), MOVHPS(0x91e), MULPS(0xc58), VCMPLTPS(0x121c), BT(0x368), MOVAPD(
			0x998), JRCXZ(0x1b8), MULPD(0xc5f), MOVS(0x127), INVLPG(0x6b4), MOVQ(
			0xf53), VMINPD(0xd89), PABSD(0x1900), SAHF(0x11b), PHSUBSW(0x1804), PI2FD(
			0x769), PABSB(0x18e2), VPANDN(0x14e8), VPUNPCKLDQ(0xe52), FDIVP(
			0x62f), PSUBQ(0x16ed), FDIVR(0x420), FDIV(0x41a), PREFETCH(0x74d), EMMS(
			0x1001), VMINPS(0xd81), VFMADD231PS(0x1db7), VFNMSUB213PD(0x1d4d), CVTSS2SI(
			0xa80), MOVHPD(0x926), CMOVZ(0x29f), VPAVGW(0x1524), CQO(0xff), VPSUBD(
			0x16e5), CMOVP(0x2cc), CMOVS(0x2bd), PMOVSXBD(0x1924), VROUNDSS(
			0x1f3d), VPSUBQ(0x16f4), CMOVL(0x2db), ADDSUBPS(0x13dc), CMOVO(
			0x281), CMOVA(0x2b6), CMOVB(0x290), PUNPCKHBW(0xec1), PCMPISTRI(
			0x20f4), CMOVG(0x2f2), VPMOVMSKB(0x1465), MOVUPD(0x82c), VFMSUBADD132PD(
			0x1b77), VPSADBW(0x1694), VROUNDPD(0x1f2a), LMSW(0x6ae), INVEPT(
			0x1b36), MOVZX(0x39f), ANDPS(0xba4), VFMSUBADD132PS(0x1b67), MOVUPS(
			0x824), PMULHUW(0x152c), VDPPD(0x205e), PEXTRD(0x1fb8), OR(0x1b), VPEXTRW(
			0x1387), VPSUBSB(0x15b4), FXRSTOR(0x108a), CLTS(0x21d), FRSTOR(
			0x5e4), PSLLW(0x1639), FLDLN2(0x48f), VINSERTF128(0x1fe8), VPSUBSW(
			0x15c5), PMULUDQ(0x1666), DEC(0x56), PMADDWD(0x1679), FLD(0x427), VPMOVZXDQ(
			0x1a66), VCVTSI2SS(0x9da), PEXTRW(0x137f), ROL(0x3cc), VFMADD132SD(
			0x1bae), CMPLEPD(0x1137), VCVTSD2SS(0xcc7), FUCOMP(0x5fa), JMP(
			0x1ce), VCMPEQSD(0x1317), CVTDQ2PS(0xce8), FUCOMI(0x5d5), LZCNT(
			0x10cf), VRCPPS(0xb9c), PMAXUB(0x14d0), VPHADDD(0x17af), VCVTSI2SD(
			0x9e5), ROR(0x3d1), INVD(0x22b), VCVTSD2SI(0xa9f), AESDEC(0x1eca), CMPNLESD(
			0x11fe), SETLE(0x354), VFMSUBADD231PS(0x1d97), VFNMADD231PS(0x1e1f), PUNPCKHWD(
			0xed8), VPMOVSXWD(0x1958), CVTPD2PS(0xc9e), VMOVHLPS(0x890), VFMSUBADD231PD(
			0x1da7), CVTPD2PI(0xa76), CMPNLESS(0x11af), PMULDQ(0x198d), VPMOVSXWQ(
			0x196d), VCMPNLTSD(0x134d), VFNMADD231PD(0x1e2d), FSTSW(0x177e), RDTSCP(
			0x745), MFENCE(0x10a9), VFMADD132SS(0x1ba1), PMINUD(0x1ab7), FENI(
			0x5bf), BOUND(0x68), VROUNDPS(0x1f17), PSHUFLW(0xfa2), VMULSS(0xc84), VCVTDQ2PS(
			0xd07), VCMPLESS(0x12d4), FNOP(0x44c), CMPNLTPS(0x1107), VCMPNLTPS(
			0x1248), FLDLG2(0x487), SYSRET(0x223), FSTCW(0x1742), VFMSUB213SS(
			0x1ced), SKINIT(0x72c), VANDPD(0xbba), FLDZ(0x497), SUB(0x33), VPHSUBSW(
			0x180d), NEG(0x659), PMINUW(0x1aa6), MAXPD(0xde4), STOS(0x133), VFNMSUB231SD(
			0x1e81), VCMPUNORDSD(0x1335), PAVGUSB(0x81b), MAXPS(0xddd), PMINUB(
			0x1496), VMASKMOVDQU(0x16b3), FBSTP(0x63c), PINSRW(0x136e), VPMOVZXWD(
			0x1a3c), VPMINUW(0x1aae), SALC(0x18a), VUNPCKLPS(0x8d5), VPMINUB(
			0x149e), MOVDQA(0xf67), VCMPNLTSS(0x12f6), PSLLQ(0x1657), VMOVNTPS(
			0xa14), VPMINUD(0x1abf), PREFETCHNTA(0x95f), VUNPCKLPD(0x8e0), VROUNDSD(
			0x1f50), VAESKEYGENASSIST(0x211c), PSUBSW(0x15bd), FNSTENV(0x1729), FNSTSW(
			0x1776), CMPNEQPD(0x114c), PAVGW(0x151d), MOVNTPD(0x9f9), FSETPM(
			0x5cd), BLENDVPS(0x1893), VFMADDSUB213PD(0x1c6f), ADD(0xb), ADC(
			0x1f), PSUBSB(0x15ac), BLENDVPD(0x189d), VPUNPCKHBW(0xecc), RDPMC(
			0x25f), MOVNTPS(0x9f0), ANDNPS(0xbc2), VCMPLTPD(0x1273), PAVGB(
			0x14f0), LEA(0xdf), VCVTTPD2DQ(0x156f), VPCMPGTB(0xe7c), VPCMPGTD(
			0xea2), FLD1(0x46a), VPMADDWD(0x1682), LES(0x14a), SETZ(0x313), VPCMPGTQ(
			0x1a7a), VMULSD(0xc8c), VFMADD213PS(0x1c9f), VCMPNLESS(0x1301), MOVHLPS(
			0x864), VPHMINPOSUW(0x1b29), VPABSD(0x1907), PSRAW(0x14ff), PFADD(
			0x7b6), VFMADDSUB132PD(0x1b57), COMISD(0xad8), PSRAD(0x150e), VMAXSS(
			0xe09), CMPUNORDSD(0x11de), FSINCOS(0x4f4), COMISS(0xad0), VFMADDSUB132PS(
			0x1b47), RCPPS(0xb86), VFNMADD132PD(0x1bfd), FXCH(0x446), DAA(0x2e), SETBE(
			0x320), VCVTPS2PD(0xcd2), ANDPD(0xbab), VFNMSUB231PS(0x1e57), FUCOMIP(
			0x643), VMULPS(0xc74), VFNMADD132PS(0x1bef), DAS(0x38), IRET(0x17a), BSWAP(
			0x3c5), PUNPCKLBW(0xe19), PMAXUW(0x1aea), VPCMPISTRM(0x20e8), ROUNDSS(
			0x1f34), VFNMADD213PS(0x1d07), VCVTTSD2SI(0xa60), VFMSUB231PD(
			0x1df8), FNSTCW(0x173a), ROUNDSD(0x1f47), CMPNLEPD(0x1160), PEXTRQ(
			0x1fc0), PMULHW(0x153f), FISTP(0x593), PMOVZXWQ(0x1a47), VCVTPD2PS(
			0xcdd), VADDSD(0xc50), PBLENDVB(0x1889), VMRESUME(0x6ce), UCOMISD(
			0xab3), PMOVZXWD(0x1a32), CVTTPD2PI(0xa33), UCOMISS(0xaaa), VPACKSSWB(
			0xe68), VADDSS(0xc48), PSHUFHW(0xf99), MWAIT(0x6e9);

	private final int id;

	OpcodeEnum(int id) {
		this.id = id;
	}

	public int getValue() {
		return id;
	}

	private static final Map<Integer, OpcodeEnum> lookup = new HashMap<Integer, OpcodeEnum>();
	static {
		for (OpcodeEnum o : EnumSet.allOf(OpcodeEnum.class))
			lookup.put(o.getValue(), o);
	}

	public static OpcodeEnum fromInt(int id) {
		return lookup.get(id);
	}

	public boolean isCall() {
		switch (this) {
		case CALL:
		case CALL_FAR:
		case SYSCALL:
		case VMCALL:
		case VMMCALL:
			return true;
		default:
			return false;
		}
	}

	public boolean isRet() {
		switch (this) {
		case RET:
		case RETF:
			return true;
		case HLT:
			return true;
		default:
			return false;
		}
	}

	public boolean isJump() {
		return isUnconditionalJump() || isConditionalJump();
	}

	public boolean isUnconditionalJump() {
		switch (this) {
		case JMP_FAR:
		case JMP:
			return true;
		default:
			return false;
		}
	}

	public boolean isConditionalJump() {
		switch (this) {
		case JA:
		case JB:
		case JCXZ:
		case JG:
		case JGE:
		case JAE:
		case JBE:
		case JECXZ:
		case JL:
		case JLE:
		case JNO:
		case JNP:
		case JNS:
		case JNZ:
		case JO:
		case JP:
		case JRCXZ:
		case JS:
		case JZ:
			return true;
		default:
			return false;
		}
	}
	
	public boolean isEndOfBb(){
		return isJump() || isRet();
	}

	public boolean isNop() {
		switch (this) {
		case NOP:
			return true;
		default:
			return false;
		}
	}
	
	
	static final boolean isDefInitialized[];
	static final boolean isUseInitialized[];
	
	static final int flagsDef[][];
	static final int flagsUse[][];

	static final int i_ = 0;			// no effect
	static final int iu = 1;			// unpredictable
	static final int ip = 2;			// predictable
	static final int i1 = 3;			// set to one
	static final int i0 = 4;			// set to zero
	
	static final int u_ = 0;			// not used
	static final int ux = 1;			// used
	static final int ud = 2;			// don't know
	
	static {
		isDefInitialized	= new boolean[OpcodeEnum.values().length];
		isUseInitialized	= new boolean[OpcodeEnum.values().length];
		flagsDef		= new int[Flags.values().length][OpcodeEnum.values().length];
		flagsUse		= new int[Flags.values().length][OpcodeEnum.values().length];

		//                O   D   I   T   S   Z   A   P   C
		defFlags( ADD,   ip, i_, i_, i_, ip, ip, ip, ip, ip );
		defFlags( ADC,   ip, i_, i_, i_, ip, ip, ip, ip, ip );
		defFlags( AND,   i0, i_, i_, i_, ip, ip, iu, ip, i0 );
		defFlags( CALL,  i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( CMP,   ip, i_, i_, i_, ip, ip, ip, ip, ip );
		defFlags( DEC,   ip, i_, i_, i_, ip, ip, ip, ip, i_ );
		defFlags( INC,   ip, i_, i_, i_, ip, ip, ip, ip, i_ );
		defFlags( DIV,   iu, i_, i_, i_, iu, iu, iu, iu, iu );
		defFlags( ENTER, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( HLT,   i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( IMUL,  ip, i_, i_, i_, iu, iu, iu, iu, ip );
		defFlags( IDIV,  iu, i_, i_, i_, iu, iu, iu, iu, iu );
		defFlags( CDQ,   i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		//                O   D   I   T   S   Z   A   P   C
		defFlags( CMOVA, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( CMOVAE,i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( CMOVB, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( CMOVBE,i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( CMOVZ, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( CMOVG, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( CMOVGE,i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( CMOVL, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( CMOVLE,i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( CMOVNZ,i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( CMOVNO,i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( CMOVNS,i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( CMOVNP,i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( CMOVO, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( CMOVP, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( CMOVS, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		//                O   D   I   T   S   Z   A   P   C
		defFlags( JA,    i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( JAE,   i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( JB,    i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( JBE,   i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( JZ,    i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( JG,    i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( JGE,   i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( JL,    i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( JLE,   i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( JNZ,   i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( JNO,   i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( JNS,   i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( JNP,   i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( JO, 	 i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( JP,    i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( JS,    i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		//                O   D   I   T   S   Z   A   P   C
		defFlags( SETA,  i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( SETAE, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( SETB,  i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( SETBE, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( SETZ,  i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( SETG,  i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( SETGE, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( SETL,  i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( SETLE, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( SETNZ, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( SETNO, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( SETNS, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( SETNP, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( SETO,  i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( SETP,  i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( SETS,  i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		//                O   D   I   T   S   Z   A   P   C
		defFlags( JMP,   i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( LEA,   i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( LEAVE, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( MOV,   i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( MOVSD, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( MOVSX, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( MOVZX, i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( MUL,   ip, i_, i_, i_, iu, iu, iu, iu, ip );
		defFlags( NEG,   ip, i_, i_, i_, ip, ip, ip, ip, ip );
		defFlags( NOP,   i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( NOT,   i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( OR,    i0, i_, i_, i_, ip, ip, iu, ip, i0 );
		defFlags( POP,   i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( PUSH,  i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( RET,   i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( SBB,   ip, i_, i_, i_, ip, ip, ip, ip, ip );
		defFlags( SUB,   ip, i_, i_, i_, ip, ip, ip, ip, ip );
		defFlags( TEST,  i0, i_, i_, i_, ip, ip, iu, ip, i0 );
		defFlags( XCHG,  i_, i_, i_, i_, i_, i_, i_, i_, i_ );
		defFlags( XOR,   i0, i_, i_, i_, ip, ip, iu, i_, i0 );
		//                O   D   I   T   S   Z   A   P   C
		defFlags( SAL,   ip, i_, i_, i_, ip, ip, iu, ip, ip );
		defFlags( SHL,   ip, i_, i_, i_, ip, ip, iu, ip, ip );
		defFlags( SAR,   ip, i_, i_, i_, ip, ip, iu, ip, ip );
		defFlags( SHR,   ip, i_, i_, i_, ip, ip, iu, ip, ip );
		//                O   D   I   T   S   Z   A   P   C

	
	
		//                O   D   I   T   S   Z   A   P   C
		useFlags( ADD,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( ADC,   u_, u_, u_, u_, u_, u_, u_, u_, ux );
		useFlags( INC,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( SUB,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( SBB,   u_, u_, u_, u_, u_, u_, u_, u_, ux );
		useFlags( DEC,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( DIV,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( IDIV,  u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( CDQ,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( MUL,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( IMUL,  u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( NEG,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( NOT,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( OR,    u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( XOR,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( AND,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( SAL,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( SHL,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( SAR,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( SHR,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		//                O   D   I   T   S   Z   A   P   C
		useFlags( MOV,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( MOVSD, u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( MOVSX, u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( MOVZX, u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( XCHG,  u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( LEA,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( POP,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( PUSH,  u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		//                O   D   I   T   S   Z   A   P   C
		useFlags( CMOVA, u_, u_, u_, u_, u_, ux, u_, u_, ux );
		useFlags( CMOVAE,u_, u_, u_, u_, u_, u_, u_, u_, ux );
		useFlags( CMOVB, u_, u_, u_, u_, u_, u_, u_, u_, ux );
		useFlags( CMOVBE,u_, u_, u_, u_, u_, ux, u_, u_, ux );
		useFlags( CMOVZ, u_, u_, u_, u_, u_, ux, u_, u_, u_ );
		useFlags( CMOVG, u_, u_, u_, u_, ux, ux, u_, u_, u_ );
		useFlags( CMOVGE,u_, u_, u_, u_, ux, u_, u_, u_, u_ );
		useFlags( CMOVL, ux, u_, u_, u_, ux, u_, u_, u_, u_ );
		useFlags( CMOVLE,ux, u_, u_, u_, ux, ux, u_, u_, u_ );
		useFlags( CMOVNZ,u_, u_, u_, u_, u_, ux, u_, u_, u_ );
		useFlags( CMOVNO,ux, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( CMOVNS,u_, u_, u_, u_, ux, u_, u_, u_, u_ );
		useFlags( CMOVNP,u_, u_, u_, u_, u_, u_, u_, ux, u_ );
		useFlags( CMOVO, ux, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( CMOVP, u_, u_, u_, u_, u_, u_, u_, ux, u_ );
		useFlags( CMOVS, u_, u_, u_, u_, ux, u_, u_, u_, u_ );
		//                O   D   I   T   S   Z   A   P   C
		useFlags( JA,    u_, u_, u_, u_, u_, ux, u_, u_, ux );
		useFlags( JAE,   u_, u_, u_, u_, u_, u_, u_, u_, ux );
		useFlags( JB,    u_, u_, u_, u_, u_, u_, u_, u_, ux );
		useFlags( JBE,   u_, u_, u_, u_, u_, ux, u_, u_, ux );
		useFlags( JZ,    u_, u_, u_, u_, u_, ux, u_, u_, u_ );
		useFlags( JG,    u_, u_, u_, u_, ux, ux, u_, u_, u_ );
		useFlags( JGE,   u_, u_, u_, u_, ux, u_, u_, u_, u_ );
		useFlags( JL,    ux, u_, u_, u_, ux, u_, u_, u_, u_ );
		useFlags( JLE,   ux, u_, u_, u_, ux, ux, u_, u_, u_ );
		useFlags( JNZ,   u_, u_, u_, u_, u_, ux, u_, u_, u_ );
		useFlags( JNO,   ux, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( JNS,   u_, u_, u_, u_, ux, u_, u_, u_, u_ );
		useFlags( JNP,   u_, u_, u_, u_, u_, u_, u_, ux, u_ );
		useFlags( JO, 	 ux, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( JP,    u_, u_, u_, u_, u_, u_, u_, ux, u_ );
		useFlags( JS,    u_, u_, u_, u_, ux, u_, u_, u_, u_ );
		useFlags( JMP,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( CMP,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( TEST,  u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		//                O   D   I   T   S   Z   A   P   C
		useFlags( SETA,  u_, u_, u_, u_, u_, ux, u_, u_, ux );
		useFlags( SETAE, u_, u_, u_, u_, u_, u_, u_, u_, ux );
		useFlags( SETB,  u_, u_, u_, u_, u_, u_, u_, u_, ux );
		useFlags( SETBE, u_, u_, u_, u_, u_, ux, u_, u_, ux );
		useFlags( SETZ,  u_, u_, u_, u_, u_, ux, u_, u_, u_ );
		useFlags( SETG,  u_, u_, u_, u_, ux, ux, u_, u_, u_ );
		useFlags( SETGE, u_, u_, u_, u_, ux, u_, u_, u_, u_ );
		useFlags( SETL,  ux, u_, u_, u_, ux, u_, u_, u_, u_ );
		useFlags( SETLE, ux, u_, u_, u_, ux, ux, u_, u_, u_ );
		useFlags( SETNZ, u_, u_, u_, u_, u_, ux, u_, u_, u_ );
		useFlags( SETNO, ux, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( SETNS, u_, u_, u_, u_, ux, u_, u_, u_, u_ );
		useFlags( SETNP, u_, u_, u_, u_, u_, u_, u_, ux, u_ );
		useFlags( SETO,  ux, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( SETP,  u_, u_, u_, u_, u_, u_, u_, ux, u_ );
		useFlags( SETS,  u_, u_, u_, u_, ux, u_, u_, u_, u_ );
		//                O   D   I   T   S   Z   A   P   C
		useFlags( LEAVE, ud, ud, ud, ud, ud, ud, ud, ud, ud );
		useFlags( HLT,   ud, ud, ud, ud, ud, ud, ud, ud, ud );
		useFlags( ENTER, ud, ud, ud, ud, ud, ud, ud, ud, ud );
		useFlags( CALL,  u_, u_, u_, u_, u_, u_, u_, u_, u_ );		// by definition
		useFlags( RET,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		useFlags( NOP,   u_, u_, u_, u_, u_, u_, u_, u_, u_ );
		//                O   D   I   T   S   Z   A   P   C
	}
	
	private static void defFlags( OpcodeEnum op,  int o,  int d,  int i,  int t,  int s,  int z,  int a,  int p,  int c ){
		assert(!isDefInitialized[op.ordinal()]);
		isDefInitialized[op.ordinal()]	= true;
		flagsDef[Flags.Overflow.ordinal()][op.ordinal()]	= o;
		flagsDef[Flags.Direction.ordinal()][op.ordinal()]	= d;
		flagsDef[Flags.Interrupt.ordinal()][op.ordinal()]	= i;
		flagsDef[Flags.Trap.ordinal()][op.ordinal()]	= t;
		flagsDef[Flags.Sign.ordinal()][op.ordinal()]	= s;
		flagsDef[Flags.Zero.ordinal()][op.ordinal()]	= z;
		flagsDef[Flags.AuxCarry.ordinal()][op.ordinal()]	= a;
		flagsDef[Flags.Parity.ordinal()][op.ordinal()]	= p;
		flagsDef[Flags.Carry.ordinal()][op.ordinal()]	= c;
	}
	
	private static void useFlags( OpcodeEnum op,  int o,  int d,  int i,  int t,  int s,  int z,  int a,  int p,  int c ){
		assert(!isUseInitialized[op.ordinal()]);
		isUseInitialized[op.ordinal()]	= true;
		flagsUse[Flags.Overflow.ordinal()][op.ordinal()]	= o;
		flagsUse[Flags.Direction.ordinal()][op.ordinal()]	= d;
		flagsUse[Flags.Interrupt.ordinal()][op.ordinal()]	= i;
		flagsUse[Flags.Trap.ordinal()][op.ordinal()]	= t;
		flagsUse[Flags.Sign.ordinal()][op.ordinal()]	= s;
		flagsUse[Flags.Zero.ordinal()][op.ordinal()]	= z;
		flagsUse[Flags.AuxCarry.ordinal()][op.ordinal()]	= a;
		flagsUse[Flags.Parity.ordinal()][op.ordinal()]	= p;
		flagsUse[Flags.Carry.ordinal()][op.ordinal()]	= c;
	}
	
	public boolean defFlag( Flags flag ){
		if( !isDefInitialized[this.ordinal()] ){
			throw new RuntimeException( "def Flags are not initialized for: " + this );
		}
		return flagsDef[flag.ordinal()][this.ordinal()] != i_;
	}

	public boolean useFlag( Flags flag ){
		if( !isUseInitialized[this.ordinal()] ){
			throw new RuntimeException( "use Flags are not initialized for: " + this );
		}
		if( flagsUse[flag.ordinal()][this.ordinal()] == ud ){
			throw new RuntimeException( "use Flags are not entirely initialized for: " + this );
		}
		return flagsUse[flag.ordinal()][this.ordinal()] == ux;
	}

};
