/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package graph;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.jgrapht.EdgeFactory;
import org.jgrapht.UndirectedGraph;

import util.Pair;

public class SimpleUndirected<V> implements UndirectedGraph<V, Pair<V, V>> {
  private Set<V>          vertices = new HashSet<V>();
  private Set<Pair<V, V>> edges    = new HashSet<Pair<V, V>>();

  public SimpleUndirected<V> complement() {
    SimpleUndirected<V> g = new SimpleUndirected<V>();
    for (V v : vertices) {
      g.addVertex(v);
    }
    for (V v : vertices) {
      for (V u : vertices) {
        if (!containsEdge(u, v)) {
          g.addEdge(u, v);
        }
      }
    }
    return g;
  }

  private Pair<V, V> makeEdge(V arg0, V arg1) {
    assert( containsVertex(arg0) );
    assert( containsVertex(arg1) );
    if (arg0.hashCode() == arg1.hashCode()) {
      assert (arg0.equals(arg1)); // We hope we never have a hash collision
    }
    if (arg0.hashCode() < arg1.hashCode()) {
      return new Pair<V, V>(arg0, arg1);
    } else {
      return new Pair<V, V>(arg1, arg0);
    }
  }


  public Pair<V, V> addEdge(V arg0, V arg1) {
    Pair<V, V> edge = makeEdge(arg0, arg1);
    edges.add(edge);
    return edge;
  }


  public boolean addEdge(V arg0, V arg1, Pair<V, V> arg2) {
    throw new RuntimeException("Not yet implemented");
  }


  public boolean addVertex(V arg0) {
    if (vertices.contains(arg0)) {
      return false;
    }
    vertices.add(arg0);
    return true;
  }


  public boolean containsEdge(Pair<V, V> arg0) {
    return edges.contains(arg0);
  }


  public boolean containsEdge(V arg0, V arg1) {
    return containsEdge( makeEdge(arg0, arg1) );
  }


  public boolean containsVertex(V arg0) {
    return vertices.contains(arg0);
  }


  public Set<Pair<V, V>> edgeSet() {
    return edges;
  }


  public Set<Pair<V, V>> edgesOf(V arg0) {
    Set<Pair<V, V>> res = new HashSet<Pair<V, V>>();
    for (Pair<V, V> edge : edges) {
      if (edge.getFirst().equals(arg0) || edge.getSecond().equals(arg0)) {
        res.add(edge);
      }
    }
    return res;

  }


  public Set<Pair<V, V>> getAllEdges(V arg0, V arg1) {
    Set<Pair<V, V>> res = new HashSet<Pair<V, V>>();
    Pair<V, V> edge = getEdge(arg0, arg1);
    if (edge != null) {
      res.add(edge);
    }
    return res;
  }


  public Pair<V, V> getEdge(V arg0, V arg1) {
    Pair<V, V> edge = makeEdge(arg0, arg1);
    if (containsEdge(edge)) {
      return edge;
    } else {
      return null;
    }
  }


  public EdgeFactory<V, Pair<V, V>> getEdgeFactory() {
    throw new RuntimeException("Not yet implemented");
  }


  public V getEdgeSource(Pair<V, V> arg0) {
    return arg0.getFirst();
  }


  public V getEdgeTarget(Pair<V, V> arg0) {
    return arg0.getSecond();
  }


  public double getEdgeWeight(Pair<V, V> arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public boolean removeAllEdges(Collection<? extends Pair<V, V>> arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public Set<Pair<V, V>> removeAllEdges(V arg0, V arg1) {
    throw new RuntimeException("Not yet implemented");
  }


  public boolean removeAllVertices(Collection<? extends V> arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public boolean removeEdge(Pair<V, V> arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public Pair<V, V> removeEdge(V arg0, V arg1) {
    throw new RuntimeException("Not yet implemented");
  }


  public boolean removeVertex(V arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public Set<V> vertexSet() {
    return vertices;
  }


  public int degreeOf(V arg0) {
    throw new RuntimeException("Not yet implemented");
  }

}
