/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package graph;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;

public class TestGraph<V> implements DirectedGraph<V, SimpleEdge<V>> {
  Set<V>             vertices = new HashSet<V>();
  Set<SimpleEdge<V>> edges    = new HashSet<SimpleEdge<V>>();


  public SimpleEdge<V> addEdge(V arg0, V arg1) {
    assert (vertices.contains(arg0));
    assert (vertices.contains(arg1));
    SimpleEdge<V> e = new SimpleEdge<V>(arg0, arg1);
    edges.add(e);
    return e;
  }


  public boolean addEdge(V arg0, V arg1, SimpleEdge<V> arg2) {
    throw new RuntimeException("Not yet implemented");
  }


  public boolean addVertex(V arg0) {
    return vertices.add(arg0);
  }


  public boolean containsEdge(SimpleEdge<V> arg0) {
    return edges.contains(arg0);
  }


  public boolean containsEdge(V arg0, V arg1) {
    return containsEdge(new SimpleEdge<V>(arg0, arg1));
  }


  public boolean containsVertex(V arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public Set<SimpleEdge<V>> edgeSet() {
    return edges;
  }


  public Set<SimpleEdge<V>> edgesOf(V arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public Set<SimpleEdge<V>> getAllEdges(V arg0, V arg1) {
    throw new RuntimeException("Not yet implemented");
  }


  public SimpleEdge<V> getEdge(V arg0, V arg1) {
    SimpleEdge<V> e = new SimpleEdge<V>(arg0, arg1);
    assert( containsEdge(e) );
    return e;
  }


  public EdgeFactory<V, SimpleEdge<V>> getEdgeFactory() {
    throw new RuntimeException("Not yet implemented");
  }


  public V getEdgeSource(SimpleEdge<V> arg0) {
    return arg0.getSrc();
  }


  public V getEdgeTarget(SimpleEdge<V> arg0) {
    return arg0.getDst();
  }


  public double getEdgeWeight(SimpleEdge<V> arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public boolean removeAllEdges(Collection<? extends SimpleEdge<V>> arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public Set<SimpleEdge<V>> removeAllEdges(V arg0, V arg1) {
    throw new RuntimeException("Not yet implemented");
  }


  public boolean removeAllVertices(Collection<? extends V> arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public boolean removeEdge(SimpleEdge<V> arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public SimpleEdge<V> removeEdge(V arg0, V arg1) {
    throw new RuntimeException("Not yet implemented");
  }


  public boolean removeVertex(V arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public Set<V> vertexSet() {
    return vertices;
  }


  public int inDegreeOf(V arg0) {
    return incomingEdgesOf(arg0).size();
  }


  public Set<SimpleEdge<V>> incomingEdgesOf(V arg0) {
    HashSet<SimpleEdge<V>> res = new HashSet<SimpleEdge<V>>();
    for (SimpleEdge<V> e : edges) {
      if (e.getDst() == arg0) {
        res.add(e);
      }
    }
    return res;
  }


  public int outDegreeOf(V arg0) {
    return outgoingEdgesOf(arg0).size();
  }


  public Set<SimpleEdge<V>> outgoingEdgesOf(V arg0) {
    HashSet<SimpleEdge<V>> res = new HashSet<SimpleEdge<V>>();
    for (SimpleEdge<V> e : edges) {
      if (e.getSrc() == arg0) {
        res.add(e);
      }
    }
    return res;
  }

}
