/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package graphviz;

import java.io.PrintStream;

import org.jgrapht.DirectedGraph;

public class DotHtmlWriter<V, E> extends DotWriter<V, E> {
  private LabelWriter<V, E> vw;

  public DotHtmlWriter(LabelWriter<V, E> vw, DirectedGraph<V, E> g) {
    super(g);
    this.vw = vw;
  }

  protected void writeVertex(V bb, PrintStream stream) {
    stream.print("  ");
    stream.print(getId(bb) + "[ ");
    stream.print("label=<");
    vw.writeVertexLabel(bb, stream);
    stream.print("> ]; ");
    stream.println();
  }

  protected void writeEdge(E e, PrintStream stream) {
    stream.print("  ");
    stream.print(getId(g.getEdgeSource(e)));
    stream.print(" -> ");
    stream.print(getId(g.getEdgeTarget(e)));
    stream.print(" [ label=\"");
    vw.writeEdgeLabel(e, stream);
    stream.print("\" ]");
    stream.println();
  }

  private String getId(V bb) {
    return getId(bb.hashCode());
    // return getId( bb.getStartAddr() );
  }

  private String getId(long addr) {
    return "_" + Long.toHexString(addr);
  }

  @Override
  protected String getNodeShape() {
    return "plaintext";
  }

}
