/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package graphviz;

import java.io.FileNotFoundException;
import java.io.PrintStream;

import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;

public abstract class DotWriter<V, E> {
  protected Graph<V, E> g;

  public DotWriter(Graph<V, E> g) {
    this.g = g;
  }

  public void write(String filename) {
    PrintStream stream;
    try {
      stream = new PrintStream(filename);
      write(stream);
      stream.close();
    } catch (FileNotFoundException e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
  }

  public void write(PrintStream stream) {
    if( isDirected() ){
      stream.print("digraph");
    } else {
      stream.print("graph");
    }
    stream.println(" {");
    stream.println("  node [ shape=" + getNodeShape() + " ];");
    for (V bb : g.vertexSet()) {
      writeVertex(bb, stream);
    }
    for (E e : g.edgeSet()) {
      writeEdge(e, stream);
    }
    stream.println("}");
  }

  protected boolean isDirected(){
    if( g instanceof DirectedGraph ){
      return true;
    } else if( g instanceof UndirectedGraph ){
      return false;
    } else {
      throw new RuntimeException( "Unknown graph type: " + g.getClass().getName() );
    }
    
  }
  
  protected abstract void writeEdge(E e, PrintStream stream);
  protected abstract void writeVertex(V bb, PrintStream stream);
  protected abstract String getNodeShape();

}
