/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package graphviz;

import graph.SimpleEdge;

import java.io.PrintStream;

import cfg.function.Function;
import cfg.function.PrgFunction;

public class FunctionLabel implements LabelWriter<Function,SimpleEdge<Function>> {
	private String prefix, sufix;
	
	public FunctionLabel(String prefix, String sufix ) {
		super();
		this.prefix = prefix;
		this.sufix = sufix;
	}


	public void writeVertexLabel(Function bb, PrintStream stream) {
		stream.print( "<TABLE BORDER=\"1\" CELLBORDER=\"0\" CELLSPACING=\"0\" " );
		if( bb instanceof PrgFunction ){
			stream.print( "HREF=\"" + prefix + "." + ((PrgFunction)bb).toString() + sufix + "\"" );
		} else {
			stream.print( "COLOR=\"BLUE\" " );
		}
		stream.print( ">" );
		
		stream.print( "<TR>" );
		stream.print( "<TD>" );
		stream.print( bb.toString() );
		stream.print( "</TD>" );
		stream.print( "</TR>" );
		
		stream.print( "</TABLE>" );
	}

	public void writeEdgeLabel(SimpleEdge<Function> e, PrintStream stream) {
	}

}
