/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package graphviz;

import graph.SimpleEdge;

import java.io.PrintStream;
import java.util.Map;

import org.apache.commons.lang.StringEscapeUtils;
import org.jgrapht.DirectedGraph;

import ast.statement.Statement;

public class LiveWriter<T> extends DotWriter<T, SimpleEdge<T>> {

  private Map<T, Statement> mapping;

  public LiveWriter(DirectedGraph<T, SimpleEdge<T>> g, Map<T, Statement> mapping) {
    super(g);
    this.mapping = mapping;
  }

  @Override
  protected void writeEdge(SimpleEdge<T> e, PrintStream stream) {
    stream.print("  ");
    stream.print(getId(g.getEdgeSource(e)));
    stream.print(" -> ");
    stream.print(getId(g.getEdgeTarget(e)));
    stream.println();
  }

  @Override
  protected void writeVertex(T bb, PrintStream stream) {
    stream.print("  ");
    stream.print(getId(bb) + "[ ");
    stream.print("label=\"");
    Statement stmt = mapping.get(bb);
    if (stmt != null) {
      stream.print(StringEscapeUtils.escapeHtml(stmt.toString()));
    }
    stream.print("\"]; ");
    stream.println();
  }

  private String getId(T bb) {
    return getId(bb.hashCode());
  }

  private String getId(long addr) {
    return "_" + Long.toHexString(addr);
  }

  @Override
  protected String getNodeShape() {
    return "rect";
  }

}
