/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package graphviz;


import java.io.PrintStream;

import cfg.basicblock.BasicBlock;
import cfg.basicblock.BbEdge;

public class SimpleLabel implements LabelWriter<BasicBlock, BbEdge> {

  public void writeVertexLabel(BasicBlock bb, PrintStream stream) {
    stream.print( bb );
  }

  public void writeEdgeLabel(BbEdge e, PrintStream stream) {
    stream.print( e.getNr() );
  }

}
