/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package graphviz.depgraph;


import java.util.Map;
import java.util.Set;

import knowledge.KnowStatements;
import knowledge.KnowVarDependency;
import knowledge.KnowledgeBase;
import knowledge.memory.KnowMemDependency;
import cfg.basicblock.BasicBlock;
import cfg.function.PrgFunction;
import cfg.statement.Statement;
import codewriter.Writer;

public class VarDependencyGraph extends GraphWriter {
  KnowVarDependency kvd;
  KnowMemDependency kmd;
  KnowStatements    ks;

  public static void print(PrgFunction func, Writer writer, KnowledgeBase base) {
    VarDependencyGraph visitor = new VarDependencyGraph(writer, base);
    visitor.process(func);
  }

  public VarDependencyGraph(Writer wr, KnowledgeBase kb) {
    super(wr);
    kvd = (KnowVarDependency) kb.getEntry(KnowVarDependency.class);
    kmd = (KnowMemDependency) kb.getEntry(KnowMemDependency.class);
    ks = (KnowStatements) kb.getEntry(KnowStatements.class);
  }

  private void process(PrgFunction func) {
    wrHeader(func);

    for (Statement stmt : ks.getStatements(func)) {
      wrVertex(stmt);
      for (Statement dep : kvd.getDependencies().get(stmt)) {
        wrEdge(stmt, dep, 0);
      }
    }

    for (BasicBlock bb : func.getGraph().vertexSet()) {
      Map<Statement, Set<Statement>> depset = kmd.getDepends(bb);
      for (Statement stmt : depset.keySet()) {
        for (Statement dep : depset.get(stmt)) {
          wrEdge(stmt, dep,1);
        }
      }
    }

    wrFooter();
  }
}
