/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package knowledge;

import graph.SimpleEdge;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;

import cfg.IrElement;
import cfg.IrTraverser;
import cfg.expression.CallExprLinked;
import cfg.function.Function;
import cfg.function.LibFunction;
import cfg.function.PrgFunction;
import cfg.function.SysFunction;

public class KnowCallDst extends KnowledgeEntry {
  private KnowledgeBase base;


  public void init(KnowledgeBase base) {
    this.base = base;
  }

  public Set<Function> getCallDst(IrElement elem) {
    KnowCallDstVisitor visitor = new KnowCallDstVisitor();
    visitor.visit(elem, null);
    return visitor.getDst();
  }

  public DirectedGraph<Function, SimpleEdge<Function>> getCallgraph() {
    HashMap<Function, Set<Function>> graph = new HashMap<Function, Set<Function>>();

    for (PrgFunction func : base.getApp().getFunctions()) {
      Set<Function> dst = getCallDst(func);
      graph.put(func, dst);
    }
    for (SysFunction func : base.getApp().getAsmfunc().getAll()) {
      graph.put(func, new HashSet<Function>());
    }
    for (LibFunction func : base.getApp().getDynlib().getFunctions()) {
      graph.put(func, new HashSet<Function>());
    }
    return new Callgraph(graph);
  }
}

class KnowCallDstVisitor extends IrTraverser<Void, Void> {

  private Set<Function> dst = new HashSet<Function>();

  public Set<Function> getDst() {
    return dst;
  }


  protected Void visitCallExprLinked(CallExprLinked obj, Void param) {
    dst.add(obj.getFunc());
    return null;
  }
}

class Callgraph implements DirectedGraph<Function, SimpleEdge<Function>> {

  private HashMap<Function, Set<Function>> graph = new HashMap<Function, Set<Function>>();

  public Callgraph(HashMap<Function, Set<Function>> graph) {
    super();
    this.graph = graph;
  }


  public SimpleEdge<Function> addEdge(Function arg0, Function arg1) {
    throw new RuntimeException("Not yet implemented");
  }


  public boolean addEdge(Function arg0, Function arg1, SimpleEdge<Function> arg2) {
    throw new RuntimeException("Not yet implemented");
  }


  public boolean addVertex(Function arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public boolean containsEdge(SimpleEdge<Function> arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public boolean containsEdge(Function arg0, Function arg1) {
    throw new RuntimeException("Not yet implemented");
  }


  public boolean containsVertex(Function arg0) {
    return graph.containsKey(arg0);
  }


  public Set<SimpleEdge<Function>> edgeSet() {
    Set<SimpleEdge<Function>> res = new HashSet<SimpleEdge<Function>>();
    for (Function v : vertexSet()) {
      res.addAll(edgesOf(v));
    }
    return res;
  }


  public Set<SimpleEdge<Function>> edgesOf(Function v) {
    Set<SimpleEdge<Function>> res = new HashSet<SimpleEdge<Function>>();
    for (Function u : graph.get(v)) {
      res.add(new SimpleEdge<Function>(v, u));
    }
    return res;
  }


  public Set<SimpleEdge<Function>> getAllEdges(Function arg0, Function arg1) {
    throw new RuntimeException("Not yet implemented");
  }


  public SimpleEdge<Function> getEdge(Function arg0, Function arg1) {
    return new SimpleEdge<Function>(arg0, arg1);
  }


  public EdgeFactory<Function, SimpleEdge<Function>> getEdgeFactory() {
    throw new RuntimeException("Not yet implemented");
  }


  public Function getEdgeSource(SimpleEdge<Function> e) {
    return e.getSrc();
  }


  public Function getEdgeTarget(SimpleEdge<Function> e) {
    return e.getDst();
  }


  public double getEdgeWeight(SimpleEdge<Function> arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public boolean removeAllEdges(Collection<? extends SimpleEdge<Function>> arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public Set<SimpleEdge<Function>> removeAllEdges(Function arg0, Function arg1) {
    throw new RuntimeException("Not yet implemented");
  }


  public boolean removeAllVertices(Collection<? extends Function> arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public boolean removeEdge(SimpleEdge<Function> arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public SimpleEdge<Function> removeEdge(Function arg0, Function arg1) {
    throw new RuntimeException("Not yet implemented");
  }


  public boolean removeVertex(Function arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public Set<Function> vertexSet() {
    return graph.keySet();
  }


  public int inDegreeOf(Function arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public Set<SimpleEdge<Function>> incomingEdgesOf(Function arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public int outDegreeOf(Function arg0) {
    throw new RuntimeException("Not yet implemented");
  }


  public Set<SimpleEdge<Function>> outgoingEdgesOf(Function arg0) {
    Set<SimpleEdge<Function>> res = new HashSet<SimpleEdge<Function>>();
    for (Function u : graph.get(arg0)) {
      res.add(getEdge(arg0, u));
    }
    return res;
  }

}
