/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package knowledge;

import cfg.IrElement;
import cfg.IrTraverser;
import cfg.expression.CallExprLinked;
import cfg.expression.CallExprPointer;
import cfg.expression.CallExprUnlinked;

public class KnowFuncCall extends KnowledgeEntry {
  @Override
  public void init(KnowledgeBase base) {
  }

  public boolean hasFuncCall(IrElement elem) {
    return KnowFuncCallVisitor.hasFuncCall(elem);
  }

}

class KnowFuncCallVisitor extends IrTraverser<Void, Void> {
  private boolean hasFuncCall = false;

  static public boolean hasFuncCall(IrElement elem) {
    KnowFuncCallVisitor visitor = new KnowFuncCallVisitor();
    visitor.visit(elem, null);
    return visitor.hasFuncCall();
  }

  public boolean hasFuncCall() {
    return hasFuncCall;
  }

  @Override
  protected Void visitCallExprLinked(CallExprLinked obj, Void param) {
    hasFuncCall = true;
    return null;
  }

  @Override
  protected Void visitCallExprUnlinked(CallExprUnlinked obj, Void param) {
    hasFuncCall = true;
    return null;
  }

  @Override
  protected Void visitCallExprPointer(CallExprPointer obj, Void param) {
    hasFuncCall = true;
    return null;
  }

}
