/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package knowledge;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

import cfg.function.Function;
import cfg.variable.VariableName;

public class KnowKilledByFunction extends KnowledgeEntry {
  private HashMap<Function, Set<VariableName>> killed = new HashMap<Function, Set<VariableName>>();
  private KnowledgeBase                        base;

  @Override
  public void init(KnowledgeBase base) {
    this.base = base;
  }

  private void addFunc(Function func) {
    HashMap<Function, Set<VariableName>> visited = new HashMap<Function, Set<VariableName>>();
    dfs(func, visited);
    killed.put(func, visited.get(func));
  }

  /**
   * Returns the variables killed by this function or killed by functions called by this function and not preserved.
   * 
   * @param func
   * @return
   */
  public Set<VariableName> getKilled(Function func) {
    if (!killed.containsKey(func)) {
      addFunc(func);
    }
    if (!killed.containsKey(func)) {
      throw new RuntimeException("Can not find \"killed\" entry for function: " + func);
    }
    return killed.get(func);
  }

  private Set<VariableName> dfs(Function v, HashMap<Function, Set<VariableName>> visited) {
    KnowLocalKilled localKilled = (KnowLocalKilled) base.getEntry(KnowLocalKilled.class);
    KnowCallDst knowCallDst = (KnowCallDst) base.getEntry(KnowCallDst.class);

    Set<VariableName> kills = new HashSet<VariableName>();
    kills.addAll(localKilled.getKills(v));
    visited.put(v, kills);

    for (Function u : knowCallDst.getCallDst(v)) {
      if (!visited.containsKey(u)) {
        dfs(u, visited);
        assert (visited.containsKey(u));
      }
      kills.addAll(visited.get(u));
    }
    kills.removeAll(v.getPreserves());
    return kills;
  }
}
