/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package knowledge;


import java.util.HashSet;
import java.util.Set;

import cfg.IrTraverser;
import cfg.expression.VariableRefLinked;
import cfg.statement.Statement;

/**
 * Knows on which other statements a object is depending on.
 */
public class KnowLinks extends KnowledgeEntry {
  private KnowledgeBase base;

  @Override
  public void init(KnowledgeBase base) {
    this.base = base;
  }

  public Set<Statement> getLinks(Object elem) {
    KnowOwner owner = (KnowOwner) base.getEntry(KnowOwner.class);
    KnowLinksVisitor visitor = new KnowLinksVisitor(owner);
    visitor.visit(elem, null);
    return visitor.getRes();
  }
}

class KnowLinksVisitor extends IrTraverser<Void, Void> {
  private Set<Statement> res = new HashSet<Statement>();
  private KnowOwner      owner;

  public KnowLinksVisitor(KnowOwner owner) {
    super();
    this.owner = owner;
  }

  public Set<Statement> getRes() {
    return res;
  }

  @Override
  protected Void visitVariableRefLinked(VariableRefLinked obj, Void param) {
    assert (obj.getReference() != null);
    if (obj.getReference() != null) {
      res.add(owner.getVarOwner(obj.getReference()));
    }
    return super.visitVariableRefLinked(obj, param);
  }
}
