/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package knowledge;


import java.util.HashMap;

import ast.Program;
import cfg.Application;

public class KnowledgeBase {
  private HashMap<Class<? extends KnowledgeEntry>, KnowledgeEntry> entries = new HashMap<Class<? extends KnowledgeEntry>, KnowledgeEntry>();
  private Application                                                  app;
  private Program                                                      prg;

  public KnowledgeBase(Application app, Program prg) {
    super();
    this.app = app;
    this.prg = prg;
  }

  public Application getApp() {
    return app;
  }

  public Program getPrg() {
    return prg;
  }

  public void clear() {
    entries = new HashMap<Class<? extends KnowledgeEntry>, KnowledgeEntry>();
  }

  public KnowledgeEntry getEntry(Class<? extends KnowledgeEntry> id) {
    if (!entries.containsKey(id)) {
      KnowledgeEntry entry;
      try {
        entry = id.newInstance();
        entry.init(this);
        entries.put(id, entry);
      } catch (InstantiationException e) {
        e.printStackTrace();
      } catch (IllegalAccessException e) {
        e.printStackTrace();
      }
    }
    return entries.get(id);
  }
}
