/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package knowledge.memory;


import java.util.Map;
import java.util.Set;

import knowledge.KnowledgeBase;
import knowledge.KnowledgeEntry;
import cfg.basicblock.BasicBlock;
import cfg.statement.Statement;

public class KnowMemDependency extends KnowledgeEntry {

  @Override
  public void init(KnowledgeBase base) {
  }

  public Map<Statement, Set<Statement>> getDepends(BasicBlock bb) {
    MemoryDependencyTraverser traverser = new MemoryDependencyTraverser();
    traverser.visit(bb, null);
    return traverser.getDepends();
  }
}
