/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package knowledge.memory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class Memory<T> {
  private HashMap<Integer, T> cellwrite = new HashMap<Integer, T>();
  private T                   dynamicWrite = null;

  public boolean hasDynamicWrite(){
    return dynamicWrite != null;
  }
  
  /**
   * Returns the statement which probably wrote the last time to the cell
   * 
   * @param nr
   * @return
   */
  public T getWriter(int nr) {
    T writer = cellwrite.get(nr);
    if (writer == null) {
      writer = dynamicWrite;
    }
    return writer;
  }

  /**
   * Gets all writers of all cells
   * 
   * @return
   */
  public Set<T> getWriter() {
    Set<T> res = new HashSet<T>(cellwrite.values());
    if (dynamicWrite != null) {
      res.add(dynamicWrite);
    }
    return res;
  }

  /**
   * set the writer of a specific memory cell
   * 
   * @param nr
   * @param t
   */
  public void setWriter(int nr, T t) {
    cellwrite.put(nr, t);
  }

  /**
   * set the writer for all memory cells, i.e. if the cell is not known
   * 
   * @param t
   */
  public void setDynamicWriter(T t) {
    assert (t != null);
    dynamicWrite = t;
    cellwrite.clear();
  }
}
