/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.ast;

import graph.SimpleEdge;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.jgrapht.DirectedGraph;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import util.Pair;
import ast.PrgFunc;
import ast.variable.Variable;
import cfg.Application;
import dataflow.DfVertex;
import dataflow.copyprop.CopyPropGb;
import dataflow.copyprop.CopyPropagation;
import dataflow.copyprop.CopyReplacer;

public class CopyPropagator extends Phase {

  public CopyPropagator(Upcompiler upcompiler) {
    super(upcompiler);
  }

  @Override
  public String getDescription() {
    return "propagating copies of variables";
  }

  @Override
  public boolean process(Application app) {
    for (PrgFunc func : app.getPrg().getFunction()) {
      int changes;
      do {
        CopyPropGb gb = new CopyPropGb();
        gb.build(func);
        DirectedGraph<DfVertex<Pair<Variable, Variable>>, SimpleEdge<DfVertex<Pair<Variable, Variable>>>> g = gb
            .getGraph();
        CopyPropagation<Variable, SimpleEdge<DfVertex<Pair<Variable, Variable>>>> prop = new CopyPropagation<Variable, SimpleEdge<DfVertex<Pair<Variable, Variable>>>>(
            g);
        prop.process();

        Map<ast.statement.Statement, Map<Variable, Variable>> defset = new HashMap<ast.statement.Statement, Map<Variable, Variable>>();
        for (ast.statement.Statement stmt : gb.getMapping().keySet()) {
          DfVertex<Pair<Variable, Variable>> value = gb.getMapping().get(stmt);
          Set<Pair<Variable, Variable>> pairset = prop.getIn().get(value);
          assert (pairset != null);
          HashMap<Variable, Variable> mapping = new HashMap<Variable, Variable>();
          for (Pair<Variable, Variable> def : pairset) {
            assert (def.getFirst() != null);
            assert (def.getSecond() != null);
            assert (!mapping.containsKey(def.getFirst()));
            mapping.put(def.getFirst(), def.getSecond());
          }
          defset.put(stmt, mapping);
        }

        // DataFlowInfo<DfVertex<Pair<Variable, Variable>>, Pair<Variable, Variable>> datinfo = new
        // DataFlowInfo<DfVertex<Pair<Variable, Variable>>, Pair<Variable, Variable>>(
        // gb.getMapping(), prop.getIn(), prop.getOut());
        // CodeWriter.write(func, datinfo, filename + "." + func.getName() + ".copy.code");

        changes = CopyReplacer.process(func.getBody(), defset);
      } while (changes > 0);
    }
    return true;
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.AST;
  }

}
