/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.ast;


import java.util.Map;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import ast.Function;
import ast.LibFuncs;
import cfg.Application;
import cfg.function.system.SystemFunctions;

public class FunctionLinker extends Phase {
  private final Map<Long, ast.Function> functions;
  
  public FunctionLinker(Upcompiler upcompiler, Map<Long, Function> functions) {
    super(upcompiler);
    this.functions = functions;
  }

  @Override
  public String getDescription() {
    return "linking functions";
  }

  @Override
  public boolean process(Application app) {
    functions.put((long) -SystemFunctions.writeInt.hashCode(), LibFuncs.writeInt);
    functions.put((long) -SystemFunctions.writeNl.hashCode(), LibFuncs.writeNl);
    functions.put((long) -SystemFunctions.writeStr.hashCode(), LibFuncs.writeStr);
    functions.put((long) -SystemFunctions.readInt.hashCode(), LibFuncs.readInt);
    functions.put((long) -SystemFunctions.ptrNew.hashCode(), LibFuncs.ptrNew);
    functions.put((long) -SystemFunctions.ptrDestroy.hashCode(), LibFuncs.ptrDestroy);

    ast.traverser.FunctionLinker.process(app.getPrg(), functions);
    return true;
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.AST;
  }

}
