/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.ast;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import ast.traverser.PointerAccessRemover;
import ast.traverser.PointerNullConstReplacer;
import cfg.Application;

public class PointerReplacer extends Phase {

  public PointerReplacer(Upcompiler upcompiler) {
    super(upcompiler);
  }

  @Override
  public String getDescription() {
    return "encapsulate pointer accesses with access functions";
  }

  @Override
  public boolean process(Application app) {
    // encapsulate pointer accesses by access functions
    PointerAccessRemover.process(app);
    // replace 0 with null
    PointerNullConstReplacer.process(app);
    return true;
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.AST;
  }

}
