/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.ast;


import java.util.ArrayList;
import java.util.List;

import knowledge.KnowTypes;
import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import ast.PrgFunc;
import ast.traverser.AstVariableCollector;
import ast.traverser.MissingTypeCheater;
import ast.type.Type;
import ast.variable.Variable;
import cfg.Application;

public class TypeReconstruction extends Phase {

  public TypeReconstruction(Upcompiler upcompiler) {
    super(upcompiler);
  }

  @Override
  public String getDescription() {
    return "find types";
  }

  @Override
  public boolean process(Application app) {
    KnowTypes kt = (KnowTypes) app.getKb().getEntry(KnowTypes.class);
    List<Variable> variables = AstVariableCollector.process(app.getPrg());
    for (ast.variable.Variable var : variables) {
      Type vt = kt.getTypeOf(var);
      var.setType(vt);
    }
    for (PrgFunc func : new ArrayList<PrgFunc>(app.getPrg().getFunction())) {
      Type vt = kt.getTypeOf(func);
      func.setReturnType(vt);
    }
    MissingTypeCheater.process(app.getPrg()); // FIXME make type recovery better to remove this hack
    return true;
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.AST;
  }

}
