/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.ast;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import ast.traverser.VariableNameRemover;
import cfg.Application;

public class VariableNamer extends Phase {

  public VariableNamer(Upcompiler upcompiler) {
    super(upcompiler);
  }

  @Override
  public String getDescription() {
    return "renaming variables";
  }

  @Override
  public boolean process(Application app) {
    VariableNameRemover.process(app.getPrg());
    ast.traverser.VariableNamer.process(app.getPrg());
    return true;
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.AST;
  }

}
