/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.cfg;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import reduction.ArrayVarReplacer;
import reduction.UnlinkedPhiDeleter;
import cfg.Application;

public class ArrayReplacer extends Phase {

  public ArrayReplacer(Upcompiler upcompiler) {
    super(upcompiler);
  }

  @Override
  public String getDescription() {
    return "replace arrays with variables";
  }

  @Override
  public boolean process(Application app) {
    SsaReduce reduce;
    do {
      app.getKb().clear();
      ArrayVarReplacer.process(app, "lar");
      upcompiler.phase(new VariableLinker(upcompiler, true, false), app);
      UnlinkedPhiDeleter.process(app);// remove unused phi functions
      reduce = new SsaReduce(upcompiler);
      upcompiler.phase(reduce, app); // why? or why have done earlier?
    } while (reduce.getRemoved() != 0);

    app.getKb().clear();
    return true;
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.SSA;
  }

}
