/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.cfg;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import reduction.ConditionReduction;
import reduction.MemoryModelEnforcer;
import cfg.Application;

public class ConditionReplacer extends Phase {

  public ConditionReplacer(Upcompiler upcompiler) {
    super(upcompiler);
  }

  @Override
  public String getDescription() {
    return "condition code reconstruction";
  }

  @Override
  public boolean process(Application app) {
    MemoryModelEnforcer mme = new MemoryModelEnforcer(app);
    ConditionReduction jred = new ConditionReduction(app.getKb(), mme);
    jred.visit(app.getFunctions(), null);
    return true;
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.SSA;
  }

}
