/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package phases.cfg;


import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;

import phases.ArtefactType;
import phases.Phase;
import phases.Upcompiler;
import cfg.Application;
import cfg.parser.IntermediateFactory;
import disassembler.diStorm3.CodeInfo;
import disassembler.diStorm3.DecomposedInst;
import disassembler.diStorm3.DecomposedResult;
import disassembler.diStorm3.distorm3;
import disassembler.diStorm3.distorm3.DecodeType;
import elffile.SectionHeader;
import elfreader.ElfReader;

public class Disassembler extends Phase {

  public Disassembler(Upcompiler upcompiler) {
    super(upcompiler);
  }

  @Override
  public String getDescription() {
    return "Disassemble binary";
  }
  
  @Override
  public boolean process(Application app) {
    try {
      app.setElfReader( new ElfReader(new RandomAccessFile(app.getFile(), "r")) );
      SectionHeader text = app.getElfReader().getElfHeader().getSection(".text");
      int size = text.size();
      long start = text.addr();
      app.getElfReader().seek(start);
      byte[] mem = app.getElfReader().getBytes(size);

      CodeInfo ci = new CodeInfo(start, mem, DecodeType.Decode32Bits, 0);
      DecomposedResult dr = new DecomposedResult(size);
      distorm3.Decompose(ci, dr);

      app.getElfReader().seek(app.getElfReader().getElfHeader().getHeader().getEntry() + 0x18); // FIXME hack
      long main = app.getElfReader().getInt();

      IntermediateFactory factory = new IntermediateFactory(main, new ArrayList<DecomposedInst>(
          Arrays.asList(dr.mInstructions)), app.getElfReader(), app);
      factory.process();
      app.setMainAddr(main);
    } catch (FileNotFoundException e) {
      e.printStackTrace();
      return false;
    } catch (IOException e) {
      e.printStackTrace();
      return false;
    }
    return true;
  }

  @Override
  public ArtefactType outArtefact() {
    return ArtefactType.SSA;
  }


}
